/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit;

import io.github.noeppi_noeppi.libx.annotation.ProcessorInterface;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.GeneratedCodec;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.LoadableModel;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.RegisteredConfig;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.RegistrationEntry;
import io.github.noeppi_noeppi.libx.config.ConfigManager;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class ModInit {
    public static final String CODEC_FQN = "com.mojang.serialization.Codec";
    public static final String RECORD_CODEC_BUILDER_FQN = "com.mojang.serialization.codecs.RecordCodecBuilder";
    public final String modid;
    public final Element modClass;
    private final Map<Integer, List<RegistrationEntry>> registration = new HashMap<Integer, List<RegistrationEntry>>();
    private final List<LoadableModel> models = new ArrayList<LoadableModel>();
    private final List<RegisteredConfig> configs = new ArrayList<RegisteredConfig>();
    private final List<GeneratedCodec> codecs = new ArrayList<GeneratedCodec>();

    public ModInit(String modid, Element modClass, Messager messager) {
        this.modid = modid;
        this.modClass = modClass;
        if (!(modClass.getEnclosingElement() instanceof PackageElement)) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Parent element of mod class is not a package", modClass);
        }
    }

    public void addRegistration(int priority, List<RegistrationEntry> entries) {
        if (!this.registration.containsKey(priority)) {
            this.registration.put(priority, new ArrayList());
        }
        List<RegistrationEntry> list = this.registration.get(priority);
        list.addAll(entries);
    }

    public void addModel(String classFqn, String fieldName, String modelNamespace, String modelPath) {
        this.models.add(new LoadableModel(classFqn, fieldName, modelNamespace.isEmpty() ? this.modid : modelNamespace, modelPath));
    }

    public void addConfig(String name, boolean client, String classFqn) {
        this.configs.add(new RegisteredConfig(name, client, classFqn));
    }

    public void addCodec(GeneratedCodec codec) {
        this.codecs.add(codec);
    }

    public void write(Filer filer, Messager messager) {
        try {
            List allReg = this.registration.entrySet().stream().sorted(Comparator.comparingInt(e -> -((Integer)e.getKey()).intValue())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
            JavaFileObject file = filer.createSourceFile(((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName() + "." + this.modClass.getSimpleName() + "$", this.modClass);
            Writer writer = file.openWriter();
            writer.write("package " + ((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName() + ";");
            writer.write("public class " + this.modClass.getSimpleName() + "${");
            writer.write("private static " + ModX.class.getCanonicalName() + " mod=null;");
            if (!this.codecs.isEmpty()) {
                writer.write("public static final " + Map.class.getCanonicalName() + "<Class<?>," + CODEC_FQN + "<?>>codecs=buildCodecs();");
                writer.write("private static final " + Map.class.getCanonicalName() + "<Class<?>," + CODEC_FQN + "<?>>buildCodecs(){");
                writer.write(ProcessorInterface.LazyMapBuilder.class.getCanonicalName() + " builder=" + ProcessorInterface.class.getCanonicalName() + ".lazyMapBuilder();");
                for (GeneratedCodec codec : this.codecs) {
                    GeneratedCodec.CodecElement param;
                    int i;
                    writer.write("builder.put(" + codec.fqn + ".class,");
                    writer.write("() -> com.mojang.serialization.codecs.RecordCodecBuilder.<" + codec.fqn + ">create(instance->");
                    writer.write("instance.group(");
                    for (i = 0; i < codec.params.size(); ++i) {
                        param = codec.params.get(i);
                        writer.write("(");
                        param.writeCode(writer);
                        writer.write(")");
                        if (i >= codec.params.size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(").apply(instance,instance.stable(");
                    writer.write("(");
                    for (i = 0; i < codec.params.size(); ++i) {
                        param = codec.params.get(i);
                        writer.write(param.typeFqnBoxed + " ctorArg" + i);
                        if (i >= codec.params.size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(")->{");
                    writer.write("return new " + codec.fqn + "(");
                    for (i = 0; i < codec.params.size(); ++i) {
                        writer.write("ctorArg" + i);
                        if (i >= codec.params.size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(");");
                    writer.write("}");
                    writer.write("))");
                    writer.write("));");
                }
                writer.write("return builder.build();");
                writer.write("}");
            }
            writer.write("public static void init(" + ModX.class.getCanonicalName() + " mod){");
            writer.write(this.modClass.getSimpleName() + "$.mod=mod;");
            for (RegisteredConfig config : this.configs) {
                writer.write(ConfigManager.class.getCanonicalName() + ".registerConfig(" + ProcessorInterface.class.getCanonicalName() + ".newRL(\"" + ModInit.quote(this.modid) + "\",\"" + ModInit.quote(config.name) + "\")," + config.classFqn + ".class," + config.client + ");");
            }
            if (!allReg.isEmpty()) {
                writer.write("((" + ModXRegistration.class.getCanonicalName() + ")mod).addRegistrationHandler(" + this.modClass.getSimpleName() + "$::register);");
            }
            if (!this.models.isEmpty()) {
                writer.write("net.minecraftforge.fml.DistExecutor.unsafeRunWhenOn(net.minecraftforge.api.distmarker.Dist.CLIENT,()->()->{");
                writer.write(ProcessorInterface.class.getCanonicalName() + ".addModListener(net.minecraftforge.client.event.ModelRegistryEvent.class," + this.modClass.getSimpleName() + "$::registerModels);");
                writer.write(ProcessorInterface.class.getCanonicalName() + ".addModListener(net.minecraftforge.client.event.ModelBakeEvent.class," + this.modClass.getSimpleName() + "$::bakeModels);");
                writer.write("});");
            }
            writer.write("}");
            if (!allReg.isEmpty()) {
                writer.write("private static void register(){");
                for (RegistrationEntry entry : allReg) {
                    writer.write("((" + ModXRegistration.class.getCanonicalName() + ")mod).register(\"" + ModInit.quote(entry.registryName) + "\"," + entry.fqn + ");");
                }
                writer.write("}");
            }
            if (!this.models.isEmpty()) {
                writer.write("@net.minecraftforge.api.distmarker.OnlyIn(net.minecraftforge.api.distmarker.Dist.CLIENT)");
                writer.write("private static void registerModels(net.minecraftforge.client.event.ModelRegistryEvent event){");
                for (LoadableModel model : this.models) {
                    writer.write("net.minecraftforge.client.model.ModelLoader.addSpecialModel(" + ProcessorInterface.class.getCanonicalName() + ".newRL(\"" + ModInit.quote(model.modelNamespace) + "\",\"" + ModInit.quote(model.modelPath) + "\"));");
                }
                writer.write("}");
                writer.write("@net.minecraftforge.api.distmarker.OnlyIn(net.minecraftforge.api.distmarker.Dist.CLIENT)");
                writer.write("private static void bakeModels(net.minecraftforge.client.event.ModelBakeEvent event){");
                for (LoadableModel model : this.models) {
                    writer.write(model.classFqn + "." + ModInit.quote(model.fieldName) + "=event.getModelRegistry().get(" + ProcessorInterface.class.getCanonicalName() + ".newRL(\"" + ModInit.quote(model.modelNamespace) + "\",\"" + ModInit.quote(model.modelPath) + "\"));");
                }
                writer.write("}");
            }
            writer.write("}\n");
            writer.close();
        }
        catch (IOException e2) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Failed to generate source code: " + e2, this.modClass);
        }
    }

    public static String quote(String str) {
        StringBuilder sb = new StringBuilder();
        for (char chr : str.toCharArray()) {
            if (chr == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (chr == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (chr == '\'') {
                sb.append("\\'");
                continue;
            }
            if (chr == '\n') {
                sb.append("\\n");
                continue;
            }
            if (chr == '\r') {
                sb.append("\\r");
                continue;
            }
            if (chr == '\t') {
                sb.append("\\t");
                continue;
            }
            if (chr == '\b') {
                sb.append("\\b");
                continue;
            }
            if (chr <= '\u001f' || chr > '\u00ff') {
                sb.append(String.format("\\u%04d", chr));
                continue;
            }
            sb.append(chr);
        }
        return sb.toString();
    }
}

