/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ChangeDimensionTrigger;
import net.minecraft.advancements.criterion.ConsumeItemTrigger;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AdvancementProviderBase
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ModX mod;
    protected final DataGenerator generator;
    private final Map<ResourceLocation, Supplier<Advancement>> advancements = new HashMap<ResourceLocation, Supplier<Advancement>>();
    private String rootId = null;
    private Supplier<Advancement> rootSupplier = null;

    public AdvancementProviderBase(ModX mod, DataGenerator generator) {
        this.mod = mod;
        this.generator = generator;
    }

    public abstract void setup();

    @Nonnull
    public String func_200397_b() {
        return this.mod.modid + " advancements";
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        this.setup();
        for (Supplier<Advancement> supplier : this.advancements.values()) {
            Advancement advancement = supplier.get();
            Path path = this.generator.func_200391_b().resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path);
        }
    }

    public AdvancementFactory root() {
        return this.root(this.mod.modid);
    }

    public AdvancementFactory root(String id) {
        return this.root(this.mod.modid, id);
    }

    public AdvancementFactory root(String namespace, String id) {
        if (id.equals("recipes")) {
            throw new IllegalStateException("Can't 'recipes' as root advancement id. Use a recipe provider to generate recipe advancements.");
        }
        if (this.rootId != null || this.rootSupplier != null) {
            throw new IllegalStateException("Can't use multiple root advancements in the same provider. Use multiple providers for this.");
        }
        if (!this.advancements.isEmpty()) {
            throw new IllegalStateException("The root advancement must be the first advancement that is configured.");
        }
        AdvancementFactory factory = new AdvancementFactory(namespace, id);
        if (this.advancements.put(factory.id, () -> factory.build()) != null) {
            throw new IllegalStateException("Duplicate root advancement: " + id);
        }
        this.rootId = id;
        this.rootSupplier = () -> factory.build();
        return factory;
    }

    public void advancement(Advancement advancement) {
        if (this.advancements.put(advancement.func_192067_g(), () -> advancement) != null) {
            throw new IllegalStateException("Duplicate advancement: " + advancement.func_192067_g());
        }
    }

    public AdvancementFactory advancement(ResourceLocation id) {
        AdvancementFactory factory = new AdvancementFactory(id);
        if (this.advancements.put(id, () -> factory.build()) != null) {
            throw new IllegalStateException("Duplicate advancement: " + id);
        }
        return factory;
    }

    public AdvancementFactory advancement(String id) {
        return this.advancement(this.idFor(id));
    }

    public Advancement dummy(ResourceLocation id) {
        return this.dummy(id, false);
    }

    public Advancement dummy(ResourceLocation id, boolean hidden) {
        return new Advancement(id, null, new DisplayInfo(new ItemStack((IItemProvider)Items.field_221803_eL), (ITextComponent)new StringTextComponent(""), (ITextComponent)new StringTextComponent(""), null, FrameType.TASK, true, true, hidden), AdvancementRewards.field_192114_a, new HashMap(), (String[][])new String[0][]);
    }

    private ResourceLocation idFor(String id) {
        if (this.rootId == null) {
            throw new IllegalStateException("On advancement providers without a root advancement only fully qualified resource locations are allowed, no plain ids.");
        }
        return new ResourceLocation(this.mod.modid, this.rootId + "/" + id);
    }

    public ICriterionInstance items(IItemProvider ... items) {
        return this.items((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b()).toArray(ItemPredicate[]::new));
    }

    @SafeVarargs
    public final ICriterionInstance items(ITag<Item> ... items) {
        return this.items((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.func_200309_a().func_200307_a(item).func_200310_b()).toArray(ItemPredicate[]::new));
    }

    public ICriterionInstance items(ItemPredicate ... items) {
        return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])items);
    }

    public TaskFactory itemTasks(IItemProvider ... items) {
        return this.itemTasks((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b()).toArray(ItemPredicate[]::new));
    }

    @SafeVarargs
    public final TaskFactory itemTasks(ITag<Item> ... items) {
        return this.itemTasks((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.func_200309_a().func_200307_a(item).func_200310_b()).toArray(ItemPredicate[]::new));
    }

    public TaskFactory itemTasks(ItemPredicate ... items) {
        return () -> (ICriterionInstance[][])Arrays.stream(items).map(item -> new ICriterionInstance[]{this.items((ItemPredicate)item)}).toArray(x$0 -> new ICriterionInstance[x$0][]);
    }

    public ICriterionInstance eat(IItemProvider food) {
        return this.eat(ItemPredicate.Builder.func_200309_a().func_200308_a(food).func_200310_b());
    }

    public ICriterionInstance eat(ITag<Item> food) {
        return this.eat(ItemPredicate.Builder.func_200309_a().func_200307_a(food).func_200310_b());
    }

    public ICriterionInstance eat(ItemPredicate food) {
        return new ConsumeItemTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, food);
    }

    public ICriterionInstance leave(RegistryKey<World> dimension) {
        return new ChangeDimensionTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, dimension, null);
    }

    public ICriterionInstance enter(RegistryKey<World> dimension) {
        return ChangeDimensionTrigger.Instance.func_233552_a_(dimension);
    }

    public ICriterionInstance changeDim(RegistryKey<World> from, RegistryKey<World> to) {
        return new ChangeDimensionTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, from, to);
    }

    public EntityPredicate.AndPredicate entity(EntityPredicate entity) {
        return EntityPredicate.AndPredicate.func_234591_a_((ILootCondition[])new ILootCondition[]{EntityHasProperty.func_237477_a_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)entity).build()});
    }

    public EntityPredicate.AndPredicate entity(EntityType<?> type) {
        return this.entity(EntityPredicate.Builder.func_203996_a().func_203998_a(type).func_204000_b());
    }

    public ItemPredicate stack(IItemProvider item, Enchantment ... enchs) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.func_200309_a().func_200308_a(item);
        for (Enchantment ench : enchs) {
            builder.func_218003_a(new EnchantmentPredicate(ench, MinMaxBounds.IntBound.func_211340_b((int)1)));
        }
        return builder.func_200310_b();
    }

    public ItemPredicate stack(ITag<Item> item, Enchantment ... enchs) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.func_200309_a().func_200307_a(item);
        for (Enchantment ench : enchs) {
            builder.func_218003_a(new EnchantmentPredicate(ench, MinMaxBounds.IntBound.func_211340_b((int)1)));
        }
        return builder.func_200310_b();
    }

    public ItemPredicate stack(Enchantment ... enchs) {
        if (enchs.length == 0) {
            throw new IllegalStateException("Don't use stack() for an any predicate. Use ItemPredicate.ANY instead.");
        }
        ItemPredicate.Builder builder = ItemPredicate.Builder.func_200309_a();
        for (Enchantment ench : enchs) {
            builder.func_218003_a(new EnchantmentPredicate(ench, MinMaxBounds.IntBound.func_211340_b((int)1)));
        }
        return builder.func_200310_b();
    }

    public ItemPredicate stack(Enchantment ench, int min) {
        return ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(ench, MinMaxBounds.IntBound.func_211340_b((int)min))).func_200310_b();
    }

    public static interface TaskFactory {
        public ICriterionInstance[][] apply();
    }

    public class AdvancementFactory {
        private final ResourceLocation id;
        private final boolean root;
        private Supplier<Advancement> parent;
        private DisplayInfo display;
        private final List<List<Criterion>> criteria = new ArrayList<List<Criterion>>();
        private AdvancementRewards reward = AdvancementRewards.field_192114_a;

        private AdvancementFactory(String namespace, String rootId) {
            this.id = new ResourceLocation(namespace, rootId + "/root");
            this.root = true;
            this.parent = () -> null;
        }

        private AdvancementFactory(ResourceLocation id) {
            this.id = id;
            this.root = false;
            this.parent = () -> null;
        }

        public AdvancementFactory parent(Advancement parent) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            this.parent = () -> parent;
            return this;
        }

        public AdvancementFactory parent(ResourceLocation id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            if (!AdvancementProviderBase.this.advancements.containsKey(id)) {
                throw new IllegalStateException("Parent advancement unknown: " + id);
            }
            this.parent = (Supplier)AdvancementProviderBase.this.advancements.get(id);
            return this;
        }

        public AdvancementFactory parent(String id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            return this.parent(AdvancementProviderBase.this.idFor(id));
        }

        public AdvancementFactory display(IItemProvider icon) {
            return this.display(new ItemStack(icon));
        }

        public AdvancementFactory display(IItemProvider icon, FrameType frame) {
            return this.display(new ItemStack(icon), frame);
        }

        public AdvancementFactory display(IItemProvider icon, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            return this.display(new ItemStack(icon), frame, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemStack icon) {
            return this.display(icon, FrameType.TASK);
        }

        public AdvancementFactory display(ItemStack icon, FrameType frame) {
            return this.display(icon, frame, !this.root, !this.root, false);
        }

        public AdvancementFactory display(ItemStack icon, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            return this.display(icon, (ITextComponent)new TranslationTextComponent("advancements." + this.id.func_110624_b() + "." + this.id.func_110623_a().replace('/', '.') + ".title"), (ITextComponent)new TranslationTextComponent("advancements." + this.id.func_110624_b() + "." + this.id.func_110623_a().replace('/', '.') + ".description"), frame, toast, chat, hidden);
        }

        public AdvancementFactory display(IItemProvider icon, ITextComponent title, ITextComponent description) {
            return this.display(new ItemStack(icon), title, description);
        }

        public AdvancementFactory display(IItemProvider icon, ITextComponent title, ITextComponent description, FrameType frame) {
            return this.display(new ItemStack(icon), title, description, frame);
        }

        public AdvancementFactory display(IItemProvider icon, ITextComponent title, ITextComponent description, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            return this.display(new ItemStack(icon), title, description, frame, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemStack icon, ITextComponent title, ITextComponent description) {
            return this.display(icon, title, description, FrameType.TASK);
        }

        public AdvancementFactory display(ItemStack icon, ITextComponent title, ITextComponent description, FrameType frame) {
            return this.display(icon, title, description, frame, !this.root, !this.root, false);
        }

        public AdvancementFactory display(ItemStack icon, ITextComponent title, ITextComponent description, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            this.display = new DisplayInfo(icon, title, description, null, frame, toast, chat, hidden);
            return this;
        }

        public AdvancementFactory task(ICriterionInstance ... criteria) {
            if (criteria.length == 0) {
                throw new IllegalStateException("Can not add empty task to advancement.");
            }
            this.criteria.add(Arrays.stream(criteria).map(Criterion::new).collect(Collectors.toList()));
            return this;
        }

        public AdvancementFactory tasks(ICriterionInstance ... criteria) {
            if (criteria.length == 0) {
                throw new IllegalStateException("Can not add empty task to advancement.");
            }
            for (ICriterionInstance instance : criteria) {
                this.criteria.add((List<Criterion>)ImmutableList.of((Object)new Criterion(instance)));
            }
            this.criteria.add(Arrays.stream(criteria).map(Criterion::new).collect(Collectors.toList()));
            return this;
        }

        public AdvancementFactory tasks(TaskFactory factory) {
            for (ICriterionInstance[] task : factory.apply()) {
                this.task(task);
            }
            return this;
        }

        public AdvancementFactory reward(AdvancementRewards reward) {
            this.reward = reward;
            return this;
        }

        private Advancement build() {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("Can not add advancement without tasks.");
            }
            HashSet<String> idsTaken = new HashSet<String>();
            String[][] criteriaIds = new String[this.criteria.size()][];
            HashMap<String, Criterion> criteriaMap = new HashMap<String, Criterion>();
            for (int i = 0; i < this.criteria.size(); ++i) {
                String[] criterionGroup = new String[this.criteria.get(i).size()];
                for (int j = 0; j < this.criteria.get(i).size(); ++j) {
                    String baseName = Objects.requireNonNull(this.criteria.get(i).get(j).func_192143_a(), "Can't build advancement: Empty criterion").func_192244_a().func_110623_a();
                    String nextId = baseName = baseName.replace('.', '_').replace('/', '_');
                    int num = 2;
                    while (idsTaken.contains(nextId)) {
                        nextId = baseName + num++;
                    }
                    idsTaken.add(nextId);
                    criterionGroup[j] = nextId;
                    criteriaMap.put(nextId, this.criteria.get(i).get(j));
                }
                criteriaIds[i] = criterionGroup;
            }
            Advancement parentAdv = this.parent.get();
            if (this.root && parentAdv != null) {
                throw new IllegalStateException("Root advancement can not have a parent.");
            }
            if (!this.root && parentAdv == null) {
                if (AdvancementProviderBase.this.rootSupplier != null) {
                    parentAdv = (Advancement)AdvancementProviderBase.this.rootSupplier.get();
                    if (parentAdv == null) {
                        throw new IllegalStateException("Root advancement configured wrongly. This is an error in LibX.");
                    }
                } else {
                    throw new IllegalStateException("This advancement provider has no default root and the advancement " + this.id + " has no root specified.");
                }
            }
            if (parentAdv != null && parentAdv.func_192068_c() == null && this.display != null) {
                throw new IllegalStateException("Can't build advancement with display and display-less parent.");
            }
            if (parentAdv != null && parentAdv.func_192068_c() != null && this.display != null && parentAdv.func_192068_c().func_193224_j() && !this.display.func_193224_j()) {
                throw new IllegalStateException("Can't build visible advancement with hidden parent.");
            }
            return new Advancement(this.id, parentAdv, this.display, this.reward, criteriaMap, criteriaIds);
        }
    }
}

