/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.LeavesBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockStateProviderBase
extends BlockStateProvider {
    public static final ResourceLocation LEAVES_PARENT = new ResourceLocation("minecraft", "block/leaves");
    protected final ModX mod;
    private static final Set<Block> manualState = new HashSet<Block>();
    private static final Set<Block> existingModel = new HashSet<Block>();
    private static final Map<Block, ModelFile> customModel = new HashMap<Block, ModelFile>();

    public BlockStateProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, mod.modid, fileHelper);
        this.mod = mod;
    }

    @Nonnull
    public final String func_200397_b() {
        return this.mod.modid + " block states and models";
    }

    protected void manualState(Block b) {
        manualState.add(b);
    }

    protected void manualModel(Block b) {
        existingModel.add(b);
    }

    protected void manualModel(Block b, ModelFile model) {
        customModel.put(b, model);
    }

    protected final void registerStatesAndModels() {
        this.setup();
        for (ResourceLocation id : ForgeRegistries.BLOCKS.getKeys()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block == null || !this.mod.modid.equals(id.func_110624_b()) || manualState.contains(block)) continue;
            if (existingModel.contains(block)) {
                this.defaultState(id, block, (ModelFile)this.models().getExistingFile(new ResourceLocation(id.func_110624_b(), "block/" + id.func_110623_a())));
                continue;
            }
            if (customModel.containsKey(block)) {
                this.defaultState(id, block, customModel.get(block));
                continue;
            }
            this.defaultState(id, block, this.defaultModel(id, block));
        }
    }

    protected abstract void setup();

    protected void defaultState(ResourceLocation id, Block block, ModelFile model) {
        if (block.func_176194_O().func_177623_d().contains(BlockStateProperties.field_208157_J)) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            for (Direction direction : BlockStateProperties.field_208157_J.func_177700_c()) {
                builder.partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)direction).addModels(new ConfiguredModel[]{new ConfiguredModel(model, direction.func_176736_b() == -1 ? direction.func_176734_d().func_176743_c().func_179524_a() * 90 : 0, (int)direction.func_176734_d().func_185119_l(), false)});
            }
        } else if (block.func_176194_O().func_177623_d().contains(BlockStateProperties.field_208155_H)) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            for (Direction direction : BlockStateProperties.field_208155_H.func_177700_c()) {
                builder.partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)direction).addModels(new ConfiguredModel[]{new ConfiguredModel(model, direction.func_176736_b() == -1 ? direction.func_176734_d().func_176743_c().func_179524_a() * 90 : 0, (int)direction.func_176734_d().func_185119_l(), false)});
            }
        } else {
            this.simpleBlock(block, model);
        }
    }

    protected ModelFile defaultModel(ResourceLocation id, Block block) {
        if (block.func_176194_O().func_177619_a().stream().allMatch(state -> state.func_185901_i() != BlockRenderType.MODEL)) {
            return this.models().getBuilder(id.func_110623_a());
        }
        if (block instanceof LeavesBlock) {
            return ((BlockModelBuilder)this.models().withExistingParent(Objects.requireNonNull(block.getRegistryName()).func_110623_a(), LEAVES_PARENT)).texture("all", this.blockTexture(block));
        }
        return this.cubeAll(block);
    }
}

