/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.config.ConfigValidator;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ConfiguredValidator<T, A extends Annotation> {
    private final ConfigValidator<T, A> validator;
    private final A annotation;

    public ConfiguredValidator(ConfigValidator<T, A> validator, A annotation) {
        this.validator = validator;
        this.annotation = annotation;
    }

    public T validate(T value, String action, List<String> path, @Nullable AtomicBoolean needsCorrection) {
        Optional<T> result = this.validator.validate(value, this.annotation);
        if (result.isPresent()) {
            LibX.logger.warn(action + ". Corrected value " + String.join((CharSequence)".", path) + " from " + value + " to " + result.get() + ".");
            if (needsCorrection != null) {
                needsCorrection.set(true);
            }
            return result.get();
        }
        return value;
    }

    public Class<A> getAnnotationClass() {
        return this.validator.annotation();
    }

    public List<String> comment() {
        return this.validator.comment(this.annotation);
    }
}

