/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.noeppi_noeppi.libx.LibX;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;

public class ResourceList {
    public static final ResourceList WHITELIST = new ResourceList(true, b -> {});
    public static final ResourceList BLACKLIST = new ResourceList(false, b -> {});
    private static final WildcardString ANY = new WildcardString((List<String>)ImmutableList.of((Object)"*"));
    private static final WildcardString NAMESPACE_MC = new WildcardString((List<String>)ImmutableList.of((Object)"minecraft"));
    private final boolean whitelist;
    private final List<Rule> rules;

    public ResourceList(boolean whitelist, Consumer<RuleBuilder> rules) {
        this.whitelist = whitelist;
        RuleBuilder builder = new RuleBuilder(whitelist);
        rules.accept(builder);
        this.rules = builder.rulesBuilderList.build();
    }

    public ResourceList(JsonObject json) {
        boolean bl = this.whitelist = !json.has("whitelist") || json.get("whitelist").getAsBoolean();
        if (!json.has("elements")) {
            throw new IllegalStateException("Resource list has no member 'elements': " + json);
        }
        if (!json.get("elements").isJsonArray()) {
            throw new IllegalStateException("Resource list has no array member 'elements': " + json.get("elements"));
        }
        JsonArray elements = json.get("elements").getAsJsonArray();
        ImmutableList.Builder rules = ImmutableList.builder();
        for (JsonElement elem : elements) {
            try {
                rules.add((Object)this.parseRule(this.whitelist, elem));
            }
            catch (IllegalStateException e) {
                LibX.logger.warn("Skipping invalid rule in resource list: " + e.getMessage());
            }
        }
        this.rules = rules.build();
    }

    public ResourceList(PacketBuffer buffer) {
        this.whitelist = buffer.readBoolean();
        int ruleSize = buffer.func_150792_a();
        ImmutableList.Builder rules = ImmutableList.builder();
        for (int i = 0; i < ruleSize; ++i) {
            rules.add((Object)this.readRule(buffer));
        }
        this.rules = rules.build();
    }

    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("whitelist", Boolean.valueOf(this.whitelist));
        JsonArray array = new JsonArray();
        for (Rule rule : this.rules) {
            array.add(rule.toJSON());
        }
        json.add("elements", (JsonElement)array);
        return json;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.whitelist);
        buffer.func_150787_b(this.rules.size());
        this.rules.forEach(rule -> rule.write(buffer));
    }

    public boolean test(ResourceLocation rl) {
        for (Rule rule : this.rules) {
            Boolean value = rule.test(rl);
            if (value == null) continue;
            return value;
        }
        return !this.whitelist;
    }

    private Rule parseRule(boolean whitelist, JsonElement json) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            String str = json.getAsJsonPrimitive().getAsString();
            return this.parseSimpleRule(whitelist, str);
        }
        if (json.isJsonObject()) {
            boolean allow;
            JsonObject obj = json.getAsJsonObject();
            boolean bl = allow = obj.has("allow") ? obj.get("allow").getAsBoolean() : whitelist;
            if (!obj.has("regex")) {
                throw new IllegalStateException("Failed to build rule for resource list: JSON object has no member 'regex': " + json);
            }
            String regex = obj.get("regex").getAsString();
            return new RegexRule(allow, regex);
        }
        throw new IllegalStateException("Failed to build rule for resource list: JSON is not a string and not an object: " + json);
    }

    private Rule readRule(PacketBuffer buffer) {
        byte id = buffer.readByte();
        if (id == 0) {
            boolean allow = buffer.readBoolean();
            int namespaceSize = buffer.func_150792_a();
            ArrayList<String> namespace = new ArrayList<String>();
            for (int i = 0; i < namespaceSize; ++i) {
                namespace.add(buffer.func_150789_c(Short.MAX_VALUE));
            }
            int pathSize = buffer.func_150792_a();
            ArrayList<String> path = new ArrayList<String>();
            for (int i = 0; i < pathSize; ++i) {
                path.add(buffer.func_150789_c(Short.MAX_VALUE));
            }
            return new SimpleRule(allow, new WildcardString(namespace), new WildcardString(path));
        }
        if (id == 1) {
            boolean allow = buffer.readBoolean();
            String regex = buffer.func_150789_c(Short.MAX_VALUE);
            return new RegexRule(allow, regex);
        }
        throw new IllegalStateException("Invalid packet: Unknown rule id: " + id);
    }

    private Rule parseSimpleRule(boolean whitelist, String str) {
        WildcardString path;
        WildcardString namespace;
        boolean allow;
        if (str.startsWith("+")) {
            allow = true;
            str = str.substring(1);
        } else if (str.startsWith("-")) {
            allow = false;
            str = str.substring(1);
        } else {
            allow = whitelist;
        }
        if (str.trim().equals("*")) {
            namespace = new WildcardString((List<String>)ImmutableList.of((Object)"*"));
            path = new WildcardString(ResourceList.parseString(str.substring(str.indexOf(58) + 1)));
        } else if (str.contains(":")) {
            if (str.indexOf(58) != str.lastIndexOf(58)) {
                throw new IllegalStateException("Failed to build rule for resource list: Invalid resource location: More than one colon." + str);
            }
            namespace = new WildcardString(ResourceList.parseString(str.substring(0, str.indexOf(58))));
            path = new WildcardString(ResourceList.parseString(str.substring(str.indexOf(58) + 1)));
        } else {
            namespace = NAMESPACE_MC;
            path = new WildcardString(ResourceList.parseString(str));
        }
        return new SimpleRule(allow, namespace, path);
    }

    private static List<String> parseString(String str) {
        if (!ResourceLocation.func_217856_c((String)str.replace("*", ""))) {
            throw new IllegalStateException("Failed to build rule for resource list: Invalid resource location identifier: " + str);
        }
        ArrayList<String> parts = new ArrayList<String>();
        boolean lastWildcard = false;
        StringTokenizer t = new StringTokenizer(str, "*", true);
        while (t.hasMoreTokens()) {
            String elem = t.nextToken();
            boolean thisWildcard = elem.trim().equals("*");
            if ((elem.isEmpty() || lastWildcard) && thisWildcard) continue;
            if (thisWildcard) {
                parts.add("*");
            } else {
                parts.add(elem);
            }
            lastWildcard = thisWildcard;
        }
        return parts;
    }

    public class RuleBuilder {
        private final boolean whitelist;
        private final ImmutableList.Builder<Rule> rulesBuilderList;

        private RuleBuilder(boolean whitelist) {
            this.whitelist = whitelist;
            this.rulesBuilderList = ImmutableList.builder();
        }

        public void simple(ResourceLocation rl) {
            this.simple(this.whitelist, rl);
        }

        public void simple(boolean allow, ResourceLocation rl) {
            this.rulesBuilderList.add((Object)new SimpleRule(allow, new WildcardString((List<String>)ImmutableList.of((Object)rl.func_110624_b())), new WildcardString((List<String>)ImmutableList.of((Object)rl.func_110623_a()))));
        }

        public void parse(String rule) {
            this.rulesBuilderList.add((Object)ResourceList.this.parseSimpleRule(this.whitelist, rule));
        }

        public void regex(@RegEx String regex) {
            this.regex(this.whitelist, regex);
        }

        public void regex(boolean allow, @RegEx String regex) {
            this.rulesBuilderList.add((Object)new RegexRule(allow, regex));
        }
    }

    private static class WildcardString {
        public final List<String> parts;
        public final LazyValue<Predicate<String>> matcher;
        public final boolean fullWildcard;

        public WildcardString(List<String> parts) {
            ImmutableList partList = (ImmutableList)parts.stream().map(String::trim).filter(str -> !str.isEmpty()).collect(ImmutableList.toImmutableList());
            this.parts = partList.isEmpty() ? ImmutableList.of((Object)"*") : partList;
            this.matcher = new LazyValue(() -> Pattern.compile("^" + this.parts.stream().map(str -> str.equals("*") ? ".*" : Pattern.quote(str)).collect(Collectors.joining()) + "$").asPredicate());
            this.fullWildcard = this.parts.stream().allMatch(str -> str.equals("*"));
        }
    }

    private class RegexRule
    implements Rule {
        private final boolean allow;
        private final String regex;
        public final LazyValue<Predicate<String>> matcher;

        public RegexRule(boolean allow, String regex) {
            this.allow = allow;
            this.regex = regex;
            this.matcher = new LazyValue(() -> Pattern.compile(regex).asPredicate());
        }

        @Override
        public Boolean test(ResourceLocation rl) {
            return ((Predicate)this.matcher.func_179281_c()).test(rl.toString()) ? Boolean.valueOf(this.allow) : null;
        }

        @Override
        public JsonElement toJSON() {
            JsonObject json = new JsonObject();
            if (this.allow != ResourceList.this.whitelist) {
                json.addProperty("allow", Boolean.valueOf(this.allow));
            }
            json.addProperty("regex", this.regex);
            return json;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeByte(1);
            buffer.writeBoolean(this.allow);
            buffer.func_211400_a(this.regex, Short.MAX_VALUE);
        }
    }

    private class SimpleRule
    implements Rule {
        private final boolean allow;
        private final WildcardString namespace;
        private final WildcardString path;

        public SimpleRule(boolean allow, WildcardString namespace, WildcardString path) {
            this.allow = allow;
            this.namespace = namespace;
            this.path = path;
        }

        @Override
        @Nullable
        public Boolean test(ResourceLocation rl) {
            if (((Predicate)this.namespace.matcher.func_179281_c()).test(rl.func_110624_b()) && ((Predicate)this.path.matcher.func_179281_c()).test(rl.func_110623_a())) {
                return this.allow;
            }
            return null;
        }

        @Override
        public JsonElement toJSON() {
            StringBuilder sb = new StringBuilder();
            if (this.allow != ResourceList.this.whitelist) {
                sb.append(this.allow ? "+" : "-");
            }
            if (this.namespace.fullWildcard && this.path.fullWildcard) {
                sb.append("*");
            } else {
                this.namespace.parts.forEach(sb::append);
                sb.append(":");
                this.path.parts.forEach(sb::append);
            }
            return new JsonPrimitive(sb.toString());
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeByte(0);
            buffer.writeBoolean(this.allow);
            buffer.func_150787_b(this.namespace.parts.size());
            this.namespace.parts.forEach(str -> buffer.func_211400_a(str, Short.MAX_VALUE));
            buffer.func_150787_b(this.path.parts.size());
            this.path.parts.forEach(str -> buffer.func_211400_a(str, Short.MAX_VALUE));
        }
    }

    private static interface Rule {
        public Boolean test(ResourceLocation var1);

        public JsonElement toJSON();

        public void write(PacketBuffer var1);
    }
}

