/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams;

import com.mojang.brigadier.CommandDispatcher;
import dev.ftb.mods.ftbteams.FTBTeamsCommon;
import dev.ftb.mods.ftbteams.client.FTBTeamsClient;
import dev.ftb.mods.ftbteams.data.FTBTeamsCommands;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import dev.ftb.mods.ftbteams.property.TeamPropertyArgument;
import java.util.function.Consumer;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.utils.EnvExecutor;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBTeams {
    public static final String MOD_ID = "ftbteams";
    public static final String MOD_NAME = "FTB Teams";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Teams");
    public static FTBTeamsCommon PROXY;

    public FTBTeams() {
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(this::registerCommands);
        LifecycleEvent.SERVER_STOPPED.register(this::serverStopped);
        LifecycleEvent.SERVER_WORLD_SAVE.register(this::worldSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        PlayerEvent.PLAYER_JOIN.register(this::playerLoggedIn);
        FTBTeamsNet.init();
        PROXY = (FTBTeamsCommon)EnvExecutor.getEnvSpecific(() -> FTBTeamsClient::new, () -> FTBTeamsCommon::new);
    }

    public void setup() {
        ArgumentTypes.func_218136_a((String)"ftbteams_team", TeamArgument.class, (IArgumentSerializer)new ArgumentSerializer(TeamArgument::create));
        ArgumentTypes.func_218136_a((String)"ftbteams_team_property", TeamPropertyArgument.class, (IArgumentSerializer)new ArgumentSerializer(TeamPropertyArgument::create));
    }

    private void serverAboutToStart(MinecraftServer server) {
        TeamManager.INSTANCE = new TeamManager(server);
        ((Consumer)TeamManagerEvent.CREATED.invoker()).accept(new TeamManagerEvent(TeamManager.INSTANCE));
        TeamManager.INSTANCE.load();
    }

    private void registerCommands(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType selection) {
        new FTBTeamsCommands().register(dispatcher);
    }

    private void serverStopped(MinecraftServer server) {
        ((Consumer)TeamManagerEvent.DESTROYED.invoker()).accept(new TeamManagerEvent(TeamManager.INSTANCE));
        TeamManager.INSTANCE = null;
    }

    private void worldSaved(ServerWorld level) {
        if (TeamManager.INSTANCE != null) {
            TeamManager.INSTANCE.saveNow();
        }
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add(TeamBase.DISPLAY_NAME);
        event.add(TeamBase.DESCRIPTION);
        event.add(TeamBase.COLOR);
        event.add(TeamBase.FREE_TO_JOIN);
    }

    private void playerLoggedIn(ServerPlayerEntity player) {
        TeamManager.INSTANCE.playerLoggedIn(player);
    }
}

