/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class ClientTeamManager {
    public static ClientTeamManager INSTANCE;
    public boolean invalid = false;
    private final UUID id;
    public final Map<UUID, ClientTeam> teamMap;
    public final Map<UUID, ClientTeam> playerTeamMap;
    public final Map<UUID, GameProfile> profileMap;
    public ClientTeam selfTeam;

    public ClientTeamManager(UUID i) {
        this.id = i;
        this.teamMap = new HashMap<UUID, ClientTeam>();
        this.playerTeamMap = new HashMap<UUID, ClientTeam>();
        this.profileMap = new HashMap<UUID, GameProfile>();
    }

    public ClientTeamManager(PacketBuffer buffer, long now) {
        this(buffer.func_179253_g());
        int ts = buffer.func_150792_a();
        for (int i = 0; i < ts; ++i) {
            ClientTeam t = new ClientTeam(this, buffer, now);
            this.teamMap.put(t.getId(), t);
        }
        int ps = buffer.func_150792_a();
        for (int i = 0; i < ps; ++i) {
            GameProfile profile = new GameProfile(buffer.func_179253_g(), buffer.func_150789_c(Short.MAX_VALUE));
            this.profileMap.put(profile.getId(), profile);
        }
    }

    public UUID getId() {
        return this.id;
    }

    public void write(PacketBuffer buffer, long now) {
        buffer.func_179252_a(this.getId());
        buffer.func_150787_b(this.teamMap.size());
        for (ClientTeam t : this.teamMap.values()) {
            t.write(buffer, now);
        }
        buffer.func_150787_b(this.profileMap.size());
        for (GameProfile profile : this.profileMap.values()) {
            buffer.func_179252_a(profile.getId());
            buffer.func_211400_a(profile.getName(), Short.MAX_VALUE);
        }
    }

    public void init(UUID self, List<TeamMessage> messages) {
        this.selfTeam = this.teamMap.get(self);
        this.selfTeam.messageHistory.addAll(messages);
        for (ClientTeam team : this.teamMap.values()) {
            for (UUID member : team.getMembers()) {
                this.playerTeamMap.put(member, team);
            }
        }
    }

    public GameProfile getProfile(UUID id) {
        GameProfile p = this.profileMap.get(id);
        if (p == null) {
            return new GameProfile(id, UUIDTypeAdapter.fromUUID((UUID)id));
        }
        return p;
    }

    @Nullable
    public ClientTeam getTeam(UUID id) {
        return this.teamMap.get(id);
    }

    public ITextComponent getName(@Nullable UUID id) {
        if (id == null || id.equals(Util.field_240973_b_)) {
            return new StringTextComponent("System").func_240699_a_(TextFormatting.LIGHT_PURPLE);
        }
        GameProfile profile = this.profileMap.get(id);
        return new StringTextComponent(profile == null ? "Unknown" : profile.getName()).func_240699_a_(TextFormatting.YELLOW);
    }
}

