/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.TeamPropertyArgument;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.jetbrains.annotations.Nullable;

public class FTBTeamsCommands {
    private Predicate<CommandSource> requiresOPorSP() {
        return source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2);
    }

    private RequiredArgumentBuilder<CommandSource, TeamArgumentProvider> teamArg() {
        return Commands.func_197056_a((String)"team", (ArgumentType)TeamArgument.create());
    }

    private String string(CommandContext<?> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    private boolean hasNoParty(CommandSource source) {
        if (source.func_197022_f() instanceof ServerPlayerEntity) {
            Team team = FTBTeamsAPI.getPlayerTeam(source.func_197022_f().func_110124_au());
            return team != null && !team.getType().isParty();
        }
        return false;
    }

    private boolean hasParty(CommandSource source, TeamRank rank) {
        if (source.func_197022_f() instanceof ServerPlayerEntity) {
            Team team = FTBTeamsAPI.getPlayerTeam(source.func_197022_f().func_110124_au());
            return team != null && team.getType().isParty() && team.getHighestRank(source.func_197022_f().func_110124_au()).is(rank);
        }
        return false;
    }

    private Team team(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        return FTBTeamsAPI.getPlayerTeam(player);
    }

    private Team teamArg(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return TeamArgument.get(context, "team");
    }

    private Team teamArg(CommandContext<CommandSource> context, TeamType type) throws CommandSyntaxException {
        Team team = this.teamArg(context);
        if (team.getType() != type) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)team.getName());
        }
        return team;
    }

    private ServerTeam serverTeamArg(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return (ServerTeam)this.teamArg(context, TeamType.SERVER);
    }

    private PartyTeam partyTeamArg(CommandContext<CommandSource> context, TeamRank rank) throws CommandSyntaxException {
        PartyTeam team = (PartyTeam)this.teamArg(context, TeamType.PARTY);
        if (rank != TeamRank.NONE && !team.getHighestRank(((CommandSource)context.getSource()).func_197035_h().func_110124_au()).is(rank)) {
            throw TeamArgument.NOT_INVITED.create((Object)team.getName());
        }
        return team;
    }

    private PartyTeam team(CommandContext<CommandSource> context, TeamRank rank) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (!(team instanceof PartyTeam)) {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        if (!team.getHighestRank(player.func_110124_au()).is(rank)) {
            throw TeamArgument.CANT_EDIT.create((Object)team.getName());
        }
        return (PartyTeam)team;
    }

    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbteams").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"party").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"create").requires(this::hasNoParty)).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManager.INSTANCE.createParty(((CommandSource)ctx.getSource()).func_197035_h(), this.string(ctx, "name")).getLeft()))).executes(ctx -> (Integer)TeamManager.INSTANCE.createParty(((CommandSource)ctx.getSource()).func_197035_h(), "").getLeft()))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"join").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSource>)ctx, TeamRank.INVITED).join((CommandSource)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"deny_invite").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSource>)ctx, TeamRank.INVITED).denyInvite((CommandSource)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"leave").requires(source -> this.hasParty((CommandSource)source, TeamRank.MEMBER))).executes(ctx -> ((PartyTeam)this.team((CommandContext<CommandSource>)ctx)).leave(((CommandSource)ctx.getSource()).func_197035_h())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"invite").requires(source -> this.hasParty((CommandSource)source, TeamRank.OFFICER))).then(Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> this.team((CommandContext<CommandSource>)ctx, TeamRank.OFFICER).invite(((CommandSource)ctx.getSource()).func_197035_h(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"kick").requires(source -> this.hasParty((CommandSource)source, TeamRank.OFFICER))).then(Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> this.team((CommandContext<CommandSource>)ctx, TeamRank.OFFICER).kick(((CommandSource)ctx.getSource()).func_197035_h(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"transfer_ownership").requires(source -> this.hasParty((CommandSource)source, TeamRank.OWNER))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> this.team((CommandContext<CommandSource>)ctx, TeamRank.OWNER).transferOwnership(((CommandSource)ctx.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"allies").requires(source -> this.hasParty((CommandSource)source, TeamRank.MEMBER))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(source -> this.hasParty((CommandSource)source, TeamRank.OFFICER))).then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> this.team((CommandContext<CommandSource>)ctx, TeamRank.OFFICER).addAlly((CommandSource)ctx.getSource(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(source -> this.hasParty((CommandSource)source, TeamRank.OFFICER))).then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> this.team((CommandContext<CommandSource>)ctx, TeamRank.OFFICER).removeAlly((CommandSource)ctx.getSource(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(source -> this.hasParty((CommandSource)source, TeamRank.MEMBER))).executes(ctx -> this.team((CommandContext<CommandSource>)ctx, TeamRank.MEMBER).listAllies((CommandSource)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"server").requires(this.requiresOPorSP())).then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManager.INSTANCE.createServer((CommandSource)ctx.getSource(), this.string(ctx, "name")).getLeft())))).then(Commands.func_197057_a((String)"delete").then(this.teamArg().executes(ctx -> this.serverTeamArg((CommandContext<CommandSource>)ctx).delete((CommandSource)ctx.getSource()))))).then(Commands.func_197057_a((String)"settings").then(this.teamArg().then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.serverTeamArg((CommandContext<CommandSource>)ctx).settings((CommandSource)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSource>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.serverTeamArg((CommandContext<CommandSource>)ctx).settings((CommandSource)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSource>)ctx, "key"), ""))))))).then(Commands.func_197057_a((String)"msg").then(Commands.func_197056_a((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.team((CommandContext<CommandSource>)ctx).msg(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"text")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").then(Commands.func_197057_a((String)"server_id").executes(ctx -> this.serverId((CommandSource)ctx.getSource())))).then(this.teamArg().executes(ctx -> this.teamArg((CommandContext<CommandSource>)ctx).info((CommandSource)ctx.getSource())))).executes(ctx -> this.team((CommandContext<CommandSource>)ctx).info((CommandSource)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").executes(ctx -> this.list((CommandSource)ctx.getSource(), null))).then(Commands.func_197057_a((String)"parties").executes(ctx -> this.list((CommandSource)ctx.getSource(), TeamType.PARTY)))).then(Commands.func_197057_a((String)"server_teams").executes(ctx -> this.list((CommandSource)ctx.getSource(), TeamType.SERVER)))).then(Commands.func_197057_a((String)"players").executes(ctx -> this.list((CommandSource)ctx.getSource(), TeamType.PLAYER)))));
    }

    private int serverId(CommandSource source) {
        StringTextComponent component = new StringTextComponent("Server ID: " + FTBTeamsAPI.getManager().getId());
        component.func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to copy"))));
        component.func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, FTBTeamsAPI.getManager().getId().toString())));
        source.func_197030_a((ITextComponent)component, false);
        return 1;
    }

    private int list(CommandSource source, @Nullable TeamType type) {
        StringTextComponent list = new StringTextComponent("");
        boolean first = true;
        for (Team team : FTBTeamsAPI.getManager().getTeams()) {
            if (type != null && team.getType() != type) continue;
            if (first) {
                first = false;
            } else {
                list.func_240702_b_(", ");
            }
            list.func_230529_a_(team.getName());
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("ftbteams.list", new Object[]{first ? new TranslationTextComponent("ftbteams.info.owner.none") : list}), false);
        return 1;
    }
}

