/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftblibrary.config.NameMap;
import net.minecraft.util.IStringSerializable;

public enum TeamRank implements IStringSerializable
{
    ENEMY("enemy", -100),
    NONE("none", 0),
    ALLY("ally", 50),
    INVITED("invited", 75),
    MEMBER("member", 100),
    OFFICER("officer", 500),
    OWNER("owner", 1000);

    public static final TeamRank[] VALUES;
    public static final NameMap<TeamRank> NAME_MAP;
    private final String name;
    private final int power;

    private TeamRank(String n2, int p) {
        this.name = n2;
        this.power = p;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getPower() {
        return this.power;
    }

    public boolean is(TeamRank rank) {
        if (rank.power > 0) {
            return this.power >= rank.power;
        }
        if (rank.power < 0) {
            return this.power <= rank.power;
        }
        return true;
    }

    public boolean isEnemy() {
        return this.is(ENEMY);
    }

    public boolean isNone() {
        return this.is(NONE);
    }

    public boolean isAlly() {
        return this.is(ALLY);
    }

    public boolean isInvited() {
        return this.is(INVITED);
    }

    public boolean isMember() {
        return this.is(MEMBER);
    }

    public boolean isOfficer() {
        return this.is(OFFICER);
    }

    public boolean isOwner() {
        return this.is(OWNER);
    }

    static {
        VALUES = TeamRank.values();
        NAME_MAP = NameMap.of((Object)((Object)NONE), (Object[])TeamRank.values()).create();
    }
}

