/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class EnumProperty
extends TeamProperty<String> {
    private final List<String> values;
    private final Map<String, ITextComponent> names;

    public EnumProperty(ResourceLocation id, String def, List<String> v, Map<String, ITextComponent> n) {
        super(id, def);
        this.values = v;
        this.names = n;
    }

    public <T> EnumProperty(ResourceLocation id, NameMap<T> nameMap) {
        super(id, nameMap.getName(nameMap.defaultValue));
        this.values = nameMap.keys;
        this.names = new HashMap<String, ITextComponent>();
        for (Object val : nameMap) {
            this.names.put(nameMap.getName(val), nameMap.getDisplayName(val));
        }
    }

    public EnumProperty(ResourceLocation id, PacketBuffer buf) {
        super(id, buf.func_150789_c(Short.MAX_VALUE));
        int sv = buf.func_150792_a();
        this.values = new ArrayList<String>(sv);
        for (int i = 0; i < sv; ++i) {
            this.values.add(buf.func_150789_c(Short.MAX_VALUE));
        }
        int sn = buf.func_150792_a();
        this.names = new HashMap<String, ITextComponent>(sn);
        for (int i = 0; i < sn; ++i) {
            this.names.put(buf.func_150789_c(Short.MAX_VALUE), buf.func_179258_d());
        }
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.ENUM;
    }

    @Override
    public Optional<String> fromString(String string) {
        return Optional.of(string);
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_211400_a((String)this.defaultValue, Short.MAX_VALUE);
        buf.func_150787_b(this.values.size());
        for (String string : this.values) {
            buf.func_211400_a(string, Short.MAX_VALUE);
        }
        buf.func_150787_b(this.names.size());
        for (Map.Entry entry : this.names.entrySet()) {
            buf.func_211400_a((String)entry.getKey(), Short.MAX_VALUE);
            buf.func_179256_a((ITextComponent)entry.getValue());
        }
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addEnum(this.id.func_110624_b() + "." + this.id.func_110623_a(), value.value, value.consumer, NameMap.of((Object)this.defaultValue, this.values).name(s -> this.names.getOrDefault(s, (ITextComponent)new StringTextComponent(s))).create());
    }

    @Override
    public INBT toNBT(String value) {
        return StringNBT.func_229705_a_((String)value);
    }

    @Override
    public Optional<String> fromNBT(INBT tag) {
        if (tag instanceof StringNBT) {
            return Optional.of(tag.func_150285_a_());
        }
        return Optional.empty();
    }
}

