/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.particles;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowParticle
extends SpriteTexturedParticle {
    private static final Random RANDOM = new Random();
    private final IAnimatedSprite spriteSet;

    protected GlowParticle(ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, IAnimatedSprite spriteSet) {
        super(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.field_187130_j *= (double)0.2f;
        if (xSpeed == 0.0 && zSpeed == 0.0) {
            this.field_187129_i *= (double)0.1f;
            this.field_187131_k *= (double)0.1f;
        }
        this.field_70544_f *= 0.75f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.field_190017_n = false;
        this.func_217566_b(spriteSet);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    protected int func_189214_a(float partialTick) {
        float age = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        age = MathHelper.func_76131_a((float)age, (float)0.0f, (float)1.0f);
        int red = super.func_189214_a(partialTick);
        int green = red & 0xFF;
        int blue = red >> 16 & 0xFF;
        if ((green += (int)(age * 15.0f * 16.0f)) > 240) {
            green = 240;
        }
        return green | blue << 16;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.func_217566_b(this.spriteSet);
    }

    static /* synthetic */ double access$1200(GlowParticle x0) {
        return x0.field_187130_j;
    }

    static /* synthetic */ double access$1500(GlowParticle x0) {
        return x0.field_187129_i;
    }

    static /* synthetic */ double access$1800(GlowParticle x0) {
        return x0.field_187131_k;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GlowSquidFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public GlowSquidFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GlowParticle particle = new GlowParticle(worldIn, x, y, z, 0.0, 0.0, 0.0, this.spriteSet);
            if (worldIn.field_73012_v.nextBoolean()) {
                particle.func_70538_b(0.6f, 1.0f, 0.8f);
            } else {
                particle.func_70538_b(0.08f, 0.4f, 0.4f);
            }
            GlowParticle glowParticle = particle;
            glowParticle.field_187130_j = glowParticle.field_187130_j * 0.2;
            if (xSpeed == 0.0 && zSpeed == 0.0) {
                glowParticle = particle;
                glowParticle.field_187129_i = glowParticle.field_187129_i * 0.1;
                glowParticle = particle;
                glowParticle.field_187131_k = glowParticle.field_187131_k * 0.1;
            }
            particle.func_187114_a((int)(8.0 / (worldIn.field_73012_v.nextDouble() * 0.8 + 0.2)));
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WaxOnFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public WaxOnFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GlowParticle particle = new GlowParticle(worldIn, x, y, z, 0.0, 0.0, 0.0, this.spriteSet);
            particle.func_70538_b(0.91f, 0.55f, 0.08f);
            this.setParticleSpeed(particle, xSpeed * 0.01 / 2.0, ySpeed * 0.01, zSpeed * 0.01 / 2.0);
            particle.func_187114_a(worldIn.field_73012_v.nextInt(30) + 10);
            return particle;
        }

        private void setParticleSpeed(GlowParticle particle, double xIn, double yIn, double zIn) {
            particle.field_187129_i = xIn;
            particle.field_187130_j = yIn;
            particle.field_187131_k = zIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WaxOffFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public WaxOffFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GlowParticle particle = new GlowParticle(worldIn, x, y, z, 0.0, 0.0, 0.0, this.spriteSet);
            particle.func_70538_b(1.0f, 0.9f, 1.0f);
            this.setParticleSpeed(particle, xSpeed * 0.01 / 2.0, ySpeed * 0.01, zSpeed * 0.01 / 2.0);
            particle.func_187114_a(worldIn.field_73012_v.nextInt(30) + 10);
            return particle;
        }

        private void setParticleSpeed(GlowParticle particle, double xIn, double yIn, double zIn) {
            particle.field_187129_i = xIn;
            particle.field_187130_j = yIn;
            particle.field_187131_k = zIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ElectricSparkFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public ElectricSparkFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GlowParticle particle = new GlowParticle(worldIn, x, y, z, 0.0, 0.0, 0.0, this.spriteSet);
            particle.func_70538_b(1.0f, 0.9f, 1.0f);
            this.setParticleSpeed(particle, xSpeed * 0.25, ySpeed * 0.25, zSpeed * 0.25);
            particle.func_187114_a(worldIn.field_73012_v.nextInt(2) + 2);
            return particle;
        }

        private void setParticleSpeed(GlowParticle particle, double xIn, double yIn, double zIn) {
            particle.field_187129_i = xIn;
            particle.field_187130_j = yIn;
            particle.field_187131_k = zIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ScrapeFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public ScrapeFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GlowParticle particle = new GlowParticle(worldIn, x, y, z, 0.0, 0.0, 0.0, this.spriteSet);
            if (worldIn.field_73012_v.nextBoolean()) {
                particle.func_70538_b(0.29f, 0.58f, 0.51f);
            } else {
                particle.func_70538_b(0.43f, 0.77f, 0.62f);
            }
            this.setParticleSpeed(particle, xSpeed * 0.01, ySpeed * 0.01, zSpeed * 0.01);
            particle.func_187114_a(worldIn.field_73012_v.nextInt(30) + 10);
            return particle;
        }

        private void setParticleSpeed(GlowParticle particle, double xIn, double yIn, double zIn) {
            particle.field_187129_i = xIn;
            particle.field_187130_j = yIn;
            particle.field_187131_k = zIn;
        }
    }
}

