/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.AbstractCandleBlock;
import com.blackgear.cavesandcliffs.core.registries.api.CCBBlockStateProperties;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBBlockTags;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CandleBlock
extends AbstractCandleBlock
implements IWaterLoggable {
    public static final IntegerProperty CANDLES = CCBBlockStateProperties.CANDLES;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 3 * (Integer)state.func_177229_b((Property)CANDLES) : 0;
    private static final Int2ObjectMap<List<Vector3d>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.func_199748_a(() -> {
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        int2ObjectMap.defaultReturnValue((Object)ImmutableList.of());
        int2ObjectMap.put(1, (Object)ImmutableList.of((Object)new Vector3d(0.5, 0.5, 0.5)));
        int2ObjectMap.put(2, (Object)ImmutableList.of((Object)new Vector3d(0.375, 0.44, 0.5), (Object)new Vector3d(0.625, 0.5, 0.44)));
        int2ObjectMap.put(3, (Object)ImmutableList.of((Object)new Vector3d(0.5, 0.313, 0.625), (Object)new Vector3d(0.375, 0.44, 0.5), (Object)new Vector3d(0.56, 0.5, 0.44)));
        int2ObjectMap.put(4, (Object)ImmutableList.of((Object)new Vector3d(0.44, 0.313, 0.56), (Object)new Vector3d(0.625, 0.44, 0.56), (Object)new Vector3d(0.375, 0.44, 0.375), (Object)new Vector3d(0.56, 0.5, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap);
    });
    private static final VoxelShape ONE_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final VoxelShape TWO_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)6.0, (double)9.0);
    private static final VoxelShape THREE_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0);
    private static final VoxelShape FOUR_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)10.0);

    public CandleBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CANDLES, (Comparable)Integer.valueOf(1))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_184586_b(handIn).func_190926_b() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            CandleBlock.extinguish(state, (IWorld)worldIn, pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)CANDLES) < 4 || super.func_196253_a(state, useContext);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_177230_c().equals((Object)this)) {
            return (BlockState)state.func_235896_a_((Property)CANDLES);
        }
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((Property)CANDLES)) {
            default: {
                return ONE_SHAPE;
            }
            case 2: {
                return TWO_SHAPE;
            }
            case 3: {
                return THREE_SHAPE;
            }
            case 4: 
        }
        return FOUR_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CANDLES, LIT, WATERLOGGED});
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            BlockState blockstate = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                CandleBlock.extinguish(blockstate, worldIn, pos);
            } else {
                worldIn.func_180501_a(pos, blockstate, 3);
            }
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return LIGHT_EMISSION.applyAsInt(state);
    }

    public static boolean canBeLit(BlockState state) {
        return state.func_177230_c().func_203417_a(CCBBlockTags.CANDLES) && (Boolean)state.func_177229_b((Property)LIT) == false && (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    @Override
    protected Iterable<Vector3d> getParticleOffsets(BlockState state) {
        return (Iterable)PARTICLE_OFFSETS.get((Object)state.func_177229_b((Property)CANDLES));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }
}

