/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.WeatheringCopper;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public interface ChangeOverTimeBlock {
    public Optional<BlockState> getNext(BlockState var1);

    public float getChanceModifier();

    default public void onRandomTick(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (rand.nextFloat() < 0.05688889f) {
            this.applyChangeOverTime(state, worldIn, pos, rand);
        }
    }

    public Enum<WeatheringCopper.WeatherState> getAge();

    default public void applyChangeOverTime(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        BlockPos withinRange;
        int distance;
        int ageToTicks = this.getAge().ordinal();
        int minAge = 0;
        int maxAge = 0;
        Iterator<BlockPos> iterator = BlockPosUtils.withinManhattan(pos, 4, 4, 4).iterator();
        while (iterator.hasNext() && (distance = (withinRange = iterator.next()).func_218139_n((Vector3i)pos)) <= 4) {
            BlockState copperState;
            Block copperPos;
            if (withinRange.equals((Object)pos) || !((copperPos = (copperState = worldIn.func_180495_p(withinRange)).func_177230_c()) instanceof ChangeOverTimeBlock)) continue;
            Enum<WeatheringCopper.WeatherState> weatheringState = ((ChangeOverTimeBlock)copperPos).getAge();
            if (this.getAge().getClass() != weatheringState.getClass()) continue;
            int stateTicks = weatheringState.ordinal();
            if (stateTicks < ageToTicks) {
                return;
            }
            if (stateTicks > ageToTicks) {
                ++maxAge;
                continue;
            }
            ++minAge;
        }
        float ticks = (float)(maxAge + 1) / (float)(maxAge + minAge + 1);
        float chance = ticks * ticks * this.getChanceModifier();
        if (rand.nextFloat() < chance) {
            this.getNext(state).ifPresent(stateIn -> worldIn.func_175656_a(pos, stateIn));
        }
    }
}

