/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.RodBlock;
import com.blackgear.cavesandcliffs.common.utils.math.UniformInt;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ParticleUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.WorldUtils;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class LightningRodBlock
extends RodBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public LightningRodBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState state = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isInWater = state.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)context.func_196000_l())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isInWater));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public int func_180656_a(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false && blockState.func_177229_b((Property)field_176387_N) == side ? 15 : 0;
    }

    public void onLightningStrike(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, worldIn, pos);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 8);
        WorldUtils.playWorldEvent(3002, worldIn, pos, ((Direction)state.func_177229_b((Property)field_176387_N)).func_176740_k().ordinal());
    }

    private void updateNeighbours(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)field_176387_N)).func_176734_d()), (Block)this);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        this.updateNeighbours(state, (World)worldIn, pos);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_72911_I() && (long)worldIn.field_73012_v.nextInt(200) <= worldIn.func_82737_E() % 200L && pos.func_177956_o() == worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p()) - 1) {
            ParticleUtils.spawnParticlesAlongAxis(((Direction)stateIn.func_177229_b((Property)field_176387_N)).func_176740_k(), worldIn, pos, 0.125, (IParticleData)ParticleTypes.field_197614_g, UniformInt.of(1, 2));
        }
    }

    public static double getSparkPositionOnAxis(Random rand, Direction.Axis xAxis, double amount, Direction.Axis zAxis) {
        double area = xAxis == zAxis ? 1.0 : 0.25;
        return amount + rand.nextDouble() * area - area / 2.0;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                this.updateNeighbours(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        BlockPos pos;
        if (worldIn.func_72911_I() && projectile instanceof TridentEntity && EnchantmentHelper.func_203192_h((ItemStack)((TridentEntity)projectile).field_203054_h) && worldIn.func_226660_f_(pos = hit.func_216350_a())) {
            LightningBoltEntity lightningBoltEntity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(worldIn);
            lightningBoltEntity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
            Entity owner = projectile.func_234616_v_();
            lightningBoltEntity.func_204809_d(owner instanceof ServerPlayerEntity ? (ServerPlayerEntity)owner : null);
            worldIn.func_217376_c((Entity)lightningBoltEntity);
            worldIn.func_184133_a(null, pos, SoundEvents.field_203275_iq, SoundCategory.WEATHER, 5.0f, 1.0f);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N, POWERED, WATERLOGGED});
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }
}

