/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.ChangeOverTimeBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;

public interface WeatheringCopper
extends ChangeOverTimeBlock {
    public static final Supplier<ImmutableBiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> new ImmutableBiMap.Builder().put((Object)CCBBlocks.COPPER_BLOCK.get(), (Object)CCBBlocks.EXPOSED_COPPER.get()).put((Object)CCBBlocks.EXPOSED_COPPER.get(), (Object)CCBBlocks.WEATHERED_COPPER.get()).put((Object)CCBBlocks.WEATHERED_COPPER.get(), (Object)CCBBlocks.OXIDIZED_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER.get(), (Object)CCBBlocks.EXPOSED_CUT_COPPER.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER.get(), (Object)CCBBlocks.WEATHERED_CUT_COPPER.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER.get(), (Object)CCBBlocks.OXIDIZED_CUT_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER_SLAB.get(), (Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.OXIDIZED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.OXIDIZED_CUT_COPPER_STAIRS.get()).build());
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());

    public static Optional<Block> getPrevious(Block blockIn) {
        return Optional.ofNullable(PREVIOUS_BY_BLOCK.get().get((Object)blockIn));
    }

    public static Block getFirst(Block blockIn) {
        Block block = blockIn;
        Block previousBlock = (Block)PREVIOUS_BY_BLOCK.get().get((Object)blockIn);
        while (previousBlock != null) {
            block = previousBlock;
            previousBlock = (Block)PREVIOUS_BY_BLOCK.get().get((Object)previousBlock);
        }
        return block;
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return WeatheringCopper.getPrevious(state.func_177230_c()).map(block -> BlockUtils.withPropertiesOf(block, state));
    }

    public static Optional<Block> getNext(Block blockIn) {
        return Optional.ofNullable(NEXT_BY_BLOCK.get().get((Object)blockIn));
    }

    public static BlockState getFirst(BlockState state) {
        return BlockUtils.withPropertiesOf(WeatheringCopper.getFirst(state.func_177230_c()), state);
    }

    @Override
    default public Optional<BlockState> getNext(BlockState state) {
        return WeatheringCopper.getNext(state.func_177230_c()).map(block -> BlockUtils.withPropertiesOf(block, state));
    }

    @Override
    default public float getChanceModifier() {
        return this.getAge() == WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static enum WeatherState {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

