/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.task;

import com.blackgear.cavesandcliffs.common.entities.CCBPose;
import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.blackgear.cavesandcliffs.core.registries.other.utils.WeightedRandom;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class LongJumpToRandomPosTask<E extends MobEntity>
extends Task<E> {
    private final RangedInteger timeBetweenLongJumps;
    private final int maxLongJumpHeight;
    private final int maxLongJumpWidth;
    private final float maxJumpVelocity;
    private final List<PossibleJump> jumpCandidates = new ArrayList<PossibleJump>();
    private Optional<Vector3d> initialPosition = Optional.empty();
    private Optional<PossibleJump> chosenJump = Optional.empty();
    private int findJumpTries;
    private long prepareJumpStart;
    private Function<E, SoundEvent> getJumpSound;

    public LongJumpToRandomPosTask(RangedInteger timeBetweenLongJumps, int maxLongJumpHeight, int maxLongJumpWidth, float maxJumpVelocity, Function<E, SoundEvent> getJumpSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)CCBAI.LONG_JUMP_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)CCBAI.LONG_JUMP_MID_JUMP.get(), (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.timeBetweenLongJumps = timeBetweenLongJumps;
        this.maxLongJumpHeight = maxLongJumpHeight;
        this.maxLongJumpWidth = maxLongJumpWidth;
        this.maxJumpVelocity = maxJumpVelocity;
        this.getJumpSound = getJumpSound;
    }

    protected boolean shouldExecute(ServerWorld worldIn, MobEntity owner) {
        return owner.func_233570_aj_() && !worldIn.func_180495_p(owner.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_226907_mc_);
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        boolean canJump;
        boolean bl = canJump = this.initialPosition.isPresent() && this.initialPosition.get().equals((Object)entityIn.func_213303_ch()) && this.findJumpTries > 0 && (this.chosenJump.isPresent() || !this.jumpCandidates.isEmpty());
        if (!canJump && !entityIn.func_213375_cj().func_218207_c((MemoryModuleType)CCBAI.LONG_JUMP_MID_JUMP.get()).isPresent()) {
            entityIn.func_213375_cj().func_218205_a((MemoryModuleType)CCBAI.LONG_JUMP_COOLDOWN_TICKS.get(), (Object)(this.timeBetweenLongJumps.func_233018_a_(worldIn.field_73012_v) / 2));
        }
        return canJump;
    }

    protected void startExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        this.chosenJump = Optional.empty();
        this.findJumpTries = 20;
        this.jumpCandidates.clear();
        this.initialPosition = Optional.of(entityIn.func_213303_ch());
        BlockPos position = entityIn.func_233580_cy_();
        int x = position.func_177958_n();
        int y = position.func_177956_o();
        int z = position.func_177952_p();
        Iterable distanceBetween = BlockPos.func_191531_b((int)(x - this.maxLongJumpWidth), (int)(y - this.maxLongJumpHeight), (int)(z - this.maxLongJumpWidth), (int)(x + this.maxLongJumpWidth), (int)(y + this.maxLongJumpHeight), (int)(z + this.maxLongJumpWidth));
        PathNavigator navigator = entityIn.func_70661_as();
        Iterator distance = distanceBetween.iterator();
        while (distance.hasNext()) {
            BlockPos pos = (BlockPos)distance.next();
            double dist = pos.func_177951_i((Vector3i)position);
            if (x == pos.func_177958_n() && z == pos.func_177952_p() || !navigator.func_188555_b(pos) || entityIn.func_184643_a(WalkNodeProcessor.func_237231_a_((IBlockReader)entityIn.field_70170_p, (BlockPos.Mutable)pos.func_239590_i_())) != 0.0f) continue;
            Optional<Vector3d> jumpVector = this.calculateOptimalJumpVector(entityIn, Vector3d.func_237489_a_((Vector3i)pos));
            BlockPos finalPos = pos;
            double finalDist = dist;
            jumpVector.ifPresent(vector -> this.jumpCandidates.add(new PossibleJump(new BlockPos((Vector3i)finalPos), (Vector3d)vector, MathHelper.func_76143_f((double)finalDist))));
        }
        return;
    }

    protected void updateTask(ServerWorld worldIn, E owner, long gameTime) {
        if (this.chosenJump.isPresent()) {
            if (gameTime - this.prepareJumpStart >= 40L) {
                ((MobEntity)owner).field_70177_z = ((MobEntity)owner).field_70761_aq;
                owner.func_213317_d(this.chosenJump.get().getJumpVector());
                owner.func_213375_cj().func_218205_a((MemoryModuleType)CCBAI.LONG_JUMP_MID_JUMP.get(), (Object)true);
                worldIn.func_217384_a(null, owner, this.getJumpSound.apply(owner), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.findJumpTries;
            Optional<PossibleJump> jumpCandidates = WeightedRandom.getRandomItem(worldIn.field_73012_v, this.jumpCandidates);
            if (jumpCandidates.isPresent()) {
                this.jumpCandidates.remove(jumpCandidates.get());
                owner.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(jumpCandidates.get().getJumpTarget()));
                PathNavigator navigator = owner.func_70661_as();
                Path path = navigator.func_179680_a(jumpCandidates.get().getJumpTarget(), 0);
                if (path == null || !path.func_224771_h()) {
                    this.chosenJump = jumpCandidates;
                    this.prepareJumpStart = gameTime;
                }
            }
        }
    }

    private Optional<Vector3d> calculateOptimalJumpVector(MobEntity entity, Vector3d Vector3d2) {
        Optional<Vector3d> jumpVector = Optional.empty();
        for (int distance = 65; distance < 85; distance += 5) {
            Optional<Vector3d> jumpVectorForAngle = this.calculateJumpVectorForAngle(entity, Vector3d2, distance);
            if (jumpVector.isPresent() && (!jumpVectorForAngle.isPresent() || !(jumpVectorForAngle.get().func_189985_c() < jumpVector.get().func_189985_c()))) continue;
            jumpVector = jumpVectorForAngle;
        }
        return jumpVector;
    }

    private Optional<Vector3d> calculateJumpVectorForAngle(MobEntity entity, Vector3d Vector3d2, int distance) {
        Vector3d pos = entity.func_213303_ch();
        Vector3d scaledPos = new Vector3d(Vector3d2.field_72450_a - pos.field_72450_a, 0.0, Vector3d2.field_72449_c - pos.field_72449_c).func_72432_b().func_186678_a(0.5);
        Vector3d2 = Vector3d2.func_178788_d(scaledPos);
        Vector3d reducedPos = Vector3d2.func_178788_d(pos);
        float angle = (float)distance * (float)Math.PI / 180.0f;
        double calculatedAngle = Math.atan2(reducedPos.field_72449_c, reducedPos.field_72450_a);
        double d1 = reducedPos.func_178786_a(0.0, reducedPos.field_72448_b, 0.0).func_189985_c();
        double d2 = Math.sqrt(d1);
        double d3 = reducedPos.field_72448_b;
        double d4 = Math.sin(2.0f * angle);
        double d5 = Math.pow(Math.cos(angle), 2.0);
        double verticalAngle = Math.sin(angle);
        double horizontalAngle = Math.cos(angle);
        double zAngle = Math.sin(calculatedAngle);
        double xAngle = Math.cos(calculatedAngle);
        double velocity = d1 * 0.8 / (d2 * d4 - 2.0 * d3 * d5);
        if (velocity < 0.0) {
            return Optional.empty();
        }
        double jumpVelocity = Math.sqrt(velocity);
        if (jumpVelocity > (double)this.maxJumpVelocity) {
            return Optional.empty();
        }
        double width = jumpVelocity * horizontalAngle;
        double height = jumpVelocity * verticalAngle;
        int i1 = MathHelper.func_76143_f((double)(d2 / width)) * 2;
        double jumpDistance = 0.0;
        Vector3d primary = null;
        for (int i = 0; i < i1 - 1; ++i) {
            double yDistance = verticalAngle / horizontalAngle - Math.pow(jumpDistance += d2 / (double)i1, 2.0) * 0.08 / (2.0 * velocity * Math.pow(horizontalAngle, 2.0));
            double xDistance = jumpDistance * xAngle;
            double zDistance = jumpDistance * zAngle;
            Vector3d secondary = new Vector3d(pos.field_72450_a + xDistance, pos.field_72448_b + yDistance, pos.field_72449_c + zDistance);
            if (primary != null && !this.isClearTransition(entity, primary, secondary)) {
                return Optional.empty();
            }
            primary = secondary;
        }
        return Optional.of(new Vector3d(width * xAngle, height, width * zAngle).func_186678_a(0.95));
    }

    private boolean isClearTransition(MobEntity entity, Vector3d firstVec, Vector3d secondVec) {
        EntitySize size = entity.func_213305_a(CCBPose.LONG_JUMPING);
        Vector3d fromVec = secondVec.func_178788_d(firstVec);
        double minSize = Math.min(size.field_220315_a, size.field_220316_b);
        int transition = MathHelper.func_76143_f((double)(fromVec.func_72433_c() / minSize));
        Vector3d normalizedVec = fromVec.func_72432_b();
        Vector3d mainVec = firstVec;
        for (int i = 0; i < transition; ++i) {
            mainVec = i == transition - 1 ? secondVec : mainVec.func_178787_e(normalizedVec.func_186678_a(minSize * 0.9));
            AxisAlignedBB boundingBox = size.func_242286_a(mainVec);
            if (entity.field_70170_p.func_226665_a__((Entity)entity, boundingBox)) continue;
            return false;
        }
        return true;
    }

    public static class PossibleJump
    extends WeightedRandom.Item {
        private final BlockPos jumpTarget;
        private final Vector3d jumpVector;

        public PossibleJump(BlockPos jumpTarget, Vector3d jumpVector, int itemWeightIn) {
            super(itemWeightIn);
            this.jumpTarget = jumpTarget;
            this.jumpVector = jumpVector;
        }

        public BlockPos getJumpTarget() {
            return this.jumpTarget;
        }

        public Vector3d getJumpVector() {
            return this.jumpVector;
        }
    }
}

