/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class SetWalkTargetFromAttackTargetIfTargetOutOfReachTask
extends Task<MobEntity> {
    private final Function<LivingEntity, Float> speedModifier;

    public SetWalkTargetFromAttackTargetIfTargetOutOfReachTask(float speed) {
        this(entity -> Float.valueOf(speed));
    }

    public SetWalkTargetFromAttackTargetIfTargetOutOfReachTask(Function<LivingEntity, Float> speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.REGISTERED));
        this.speedModifier = speedModifier;
    }

    protected void startExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        LivingEntity attackTarget = (LivingEntity)entityIn.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
        if (BrainUtil.func_233876_c_((LivingEntity)entityIn, (LivingEntity)attackTarget) && BrainUtil.func_233861_a_((LivingEntity)entityIn, (LivingEntity)attackTarget, (double)1.0)) {
            this.clearWalkTarget((LivingEntity)entityIn);
        } else {
            this.setWalkAndLookTarget((LivingEntity)entityIn, attackTarget);
        }
    }

    private void setWalkAndLookTarget(LivingEntity entity, LivingEntity target) {
        Brain brain = entity.func_213375_cj();
        brain.func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)target, true));
        WalkTarget walkTarget = new WalkTarget((IPosWrapper)new EntityPosWrapper((Entity)target, false), this.speedModifier.apply(entity).floatValue(), 0);
        brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)walkTarget);
    }

    private void clearWalkTarget(LivingEntity entity) {
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
    }
}

