/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.items;

import com.blackgear.cavesandcliffs.common.utils.math.UniformInt;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ActionResultUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ParticleUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HoneyCombItem
extends Item {
    public static final ImmutableBiMap<Block, Block> WAXABLES = new ImmutableBiMap.Builder().put((Object)CCBBlocks.COPPER_BLOCK.get(), (Object)CCBBlocks.WAXED_COPPER_BLOCK.get()).put((Object)CCBBlocks.EXPOSED_COPPER.get(), (Object)CCBBlocks.WAXED_EXPOSED_COPPER.get()).put((Object)CCBBlocks.WEATHERED_COPPER.get(), (Object)CCBBlocks.WAXED_WEATHERED_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER.get(), (Object)CCBBlocks.WAXED_CUT_COPPER.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_STAIRS.get()).build();
    public static final BiMap<Block, Block> WAX_OFF_BY_BLOCK = WAXABLES.inverse();

    public HoneyCombItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = worldIn.func_180495_p(pos);
        return HoneyCombItem.getWaxed(state).map(stateIn -> {
            context.func_195996_i().func_190918_g(1);
            worldIn.func_180501_a(pos, stateIn, 11);
            PlayerEntity player = context.func_195999_j();
            ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.GLOW.get(), UniformInt.of(3, 5));
            worldIn.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_HONEYCOMB_WAX_ON.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultUtils.sidedSuccess(worldIn.field_72995_K);
        }).orElse(ActionResultType.PASS);
    }

    public static Optional<BlockState> getWaxed(BlockState state) {
        return Optional.ofNullable(WAXABLES.get((Object)state.func_177230_c())).map(block -> BlockUtils.withPropertiesOf(block, state));
    }
}

