/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils;

import com.blackgear.cavesandcliffs.common.blocks.LayeredCauldronBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface CauldronInteraction {
    public static final Map<Item, CauldronInteraction> EMPTY = CauldronInteraction.newInteractionMap();
    public static final Map<Item, CauldronInteraction> WATER = CauldronInteraction.newInteractionMap();
    public static final Map<Item, CauldronInteraction> LAVA = CauldronInteraction.newInteractionMap();
    public static final Map<Item, CauldronInteraction> POWDER_SNOW = CauldronInteraction.newInteractionMap();
    public static final CauldronInteraction FILL_WATER = (state, worldIn, pos, playerIn, handIn, stack) -> CauldronInteraction.emptyBucket(worldIn, pos, playerIn, handIn, stack, (BlockState)((Block)CCBBlocks.WATER_CAULDRON.get()).func_176223_P().func_206870_a((Property)LayeredCauldronBlock.FLUID_LEVEL, (Comparable)Integer.valueOf(3)), SoundEvents.field_187624_K);
    public static final CauldronInteraction FILL_LAVA = (state, worldIn, pos, playerIn, handIn, stack) -> CauldronInteraction.emptyBucket(worldIn, pos, playerIn, handIn, stack, ((Block)CCBBlocks.LAVA_CAULDRON.get()).func_176223_P(), SoundEvents.field_187627_L);
    public static final CauldronInteraction FILL_POWDER_SNOW = (state, worldIn, pos, playerIn, handIn, stack) -> CauldronInteraction.emptyBucket(worldIn, pos, playerIn, handIn, stack, (BlockState)((Block)CCBBlocks.POWDER_SNOW_CAULDRON.get()).func_176223_P().func_206870_a((Property)LayeredCauldronBlock.FLUID_LEVEL, (Comparable)Integer.valueOf(3)), (SoundEvent)CCBSoundEvents.ITEM_BUCKET_EMPTY_POWDER_SNOW.get());
    public static final CauldronInteraction SHULKER_BOX = (state, worldIn, pos, playerIn, handIn, stack) -> {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (!(block instanceof ShulkerBoxBlock)) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K) {
            ItemStack itemStack = new ItemStack((IItemProvider)Blocks.field_204409_il);
            if (stack.func_77942_o()) {
                itemStack.func_77982_d(stack.func_77978_p().func_74737_b());
            }
            playerIn.func_184611_a(handIn, itemStack);
            playerIn.func_195066_a(Stats.field_212740_X);
            LayeredCauldronBlock.lowerFillLevel(state, worldIn, pos);
        }
        return ActionResultType.SUCCESS;
    };
    public static final CauldronInteraction BANNER = (state, worldIn, pos, playerIn, handIn, stack) -> {
        if (BannerTileEntity.func_175113_c((ItemStack)stack) <= 0) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K) {
            ItemStack itemStack = stack.func_77946_l();
            itemStack.func_190920_e(1);
            BannerTileEntity.func_175117_e((ItemStack)itemStack);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b()) {
                playerIn.func_184611_a(handIn, itemStack);
            } else if (playerIn.field_71071_by.func_70441_a(itemStack)) {
                ((ServerPlayerEntity)playerIn).func_71120_a((Container)playerIn.field_71069_bz);
            } else {
                playerIn.func_71019_a(itemStack, false);
            }
            playerIn.func_195066_a(Stats.field_188080_N);
            LayeredCauldronBlock.lowerFillLevel(state, worldIn, pos);
        }
        return ActionResultType.SUCCESS;
    };
    public static final CauldronInteraction DYED_ITEM = (state, worldIn, pos, playerIn, handIn, stack) -> {
        Item item = stack.func_77973_b();
        if (!(item instanceof IDyeableArmorItem)) {
            return ActionResultType.PASS;
        }
        IDyeableArmorItem armorItem = (IDyeableArmorItem)item;
        if (!armorItem.func_200883_f_(stack)) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K) {
            armorItem.func_200884_g(stack);
            playerIn.func_195066_a(Stats.field_188079_M);
            LayeredCauldronBlock.lowerFillLevel(state, worldIn, pos);
        }
        return ActionResultType.SUCCESS;
    };

    public static Object2ObjectOpenHashMap<Item, CauldronInteraction> newInteractionMap() {
        return (Object2ObjectOpenHashMap)Util.func_200696_a((Object)new Object2ObjectOpenHashMap(), object2ObjectOpenHashMap -> object2ObjectOpenHashMap.defaultReturnValue((state, world, pos, playerIn, handIn, stack) -> ActionResultType.PASS));
    }

    public ActionResultType interact(BlockState var1, World var2, BlockPos var3, PlayerEntity var4, Hand var5, ItemStack var6);

    public static void bootstrap() {
        EMPTY.put(Items.field_151131_as, FILL_WATER);
        EMPTY.put(Items.field_151129_at, FILL_LAVA);
        EMPTY.put((Item)CCBItems.POWDER_SNOW_BUCKET.get(), FILL_POWDER_SNOW);
        EMPTY.put(Items.field_151068_bn, (state, worldIn, pos, playerIn, handIn, stack) -> {
            if (PotionUtils.func_185191_c((ItemStack)stack) != Potions.field_185230_b) {
                return ActionResultType.PASS;
            }
            if (!worldIn.field_72995_K) {
                playerIn.func_184611_a(handIn, ItemUtils.createFilledResult(stack, playerIn, new ItemStack((IItemProvider)Items.field_151069_bo)));
                playerIn.func_195066_a(Stats.field_188078_L);
                worldIn.func_175656_a(pos, ((Block)CCBBlocks.WATER_CAULDRON.get()).func_176223_P());
                worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        });
        WATER.put(Items.field_151129_at, FILL_LAVA);
        WATER.put(Items.field_151131_as, FILL_WATER);
        WATER.put((Item)CCBItems.POWDER_SNOW_BUCKET.get(), FILL_POWDER_SNOW);
        WATER.put(Items.field_151133_ar, (state, worldIn, pos, playerIn, handIn, stack) -> CauldronInteraction.fillBucket(state, worldIn, pos, playerIn, handIn, stack, new ItemStack((IItemProvider)Items.field_151131_as), blockstate -> (Integer)blockstate.func_177229_b((Property)LayeredCauldronBlock.FLUID_LEVEL) == 3, SoundEvents.field_187630_M));
        WATER.put(Items.field_151069_bo, (state, worldIn, pos, playerIn, handIn, stack) -> {
            if (!worldIn.field_72995_K) {
                playerIn.func_184611_a(handIn, ItemUtils.createFilledResult(stack, playerIn, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b)));
                playerIn.func_195066_a(Stats.field_188078_L);
                LayeredCauldronBlock.lowerFillLevel(state, worldIn, pos);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        });
        WATER.put(Items.field_151068_bn, (state, worldIn, pos, playerIn, handIn, stack) -> {
            if ((Integer)state.func_177229_b((Property)LayeredCauldronBlock.FLUID_LEVEL) != 3 && PotionUtils.func_185191_c((ItemStack)stack) == Potions.field_185230_b) {
                if (!worldIn.field_72995_K) {
                    playerIn.func_184611_a(handIn, ItemUtils.createFilledResult(stack, playerIn, new ItemStack((IItemProvider)Items.field_151069_bo)));
                    playerIn.func_195066_a(Stats.field_188078_L);
                    worldIn.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)LayeredCauldronBlock.FLUID_LEVEL));
                    worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        WATER.put(Items.field_151021_T, DYED_ITEM);
        WATER.put(Items.field_151026_S, DYED_ITEM);
        WATER.put(Items.field_151027_R, DYED_ITEM);
        WATER.put(Items.field_151024_Q, DYED_ITEM);
        WATER.put(Items.field_222110_op, DYED_ITEM);
        WATER.put(Items.field_196191_eg, BANNER);
        WATER.put(Items.field_196198_en, BANNER);
        WATER.put(Items.field_196206_ev, BANNER);
        WATER.put(Items.field_196202_er, BANNER);
        WATER.put(Items.field_196203_es, BANNER);
        WATER.put(Items.field_196200_ep, BANNER);
        WATER.put(Items.field_196204_et, BANNER);
        WATER.put(Items.field_196194_ej, BANNER);
        WATER.put(Items.field_196199_eo, BANNER);
        WATER.put(Items.field_196196_el, BANNER);
        WATER.put(Items.field_196193_ei, BANNER);
        WATER.put(Items.field_196192_eh, BANNER);
        WATER.put(Items.field_196197_em, BANNER);
        WATER.put(Items.field_196201_eq, BANNER);
        WATER.put(Items.field_196205_eu, BANNER);
        WATER.put(Items.field_196195_ek, BANNER);
        WATER.put(Items.field_221972_gr, SHULKER_BOX);
        WATER.put(Items.field_221986_gy, SHULKER_BOX);
        WATER.put(Items.field_221897_gG, SHULKER_BOX);
        WATER.put(Items.field_221889_gC, SHULKER_BOX);
        WATER.put(Items.field_221891_gD, SHULKER_BOX);
        WATER.put(Items.field_221885_gA, SHULKER_BOX);
        WATER.put(Items.field_221893_gE, SHULKER_BOX);
        WATER.put(Items.field_221978_gu, SHULKER_BOX);
        WATER.put(Items.field_221988_gz, SHULKER_BOX);
        WATER.put(Items.field_221982_gw, SHULKER_BOX);
        WATER.put(Items.field_221976_gt, SHULKER_BOX);
        WATER.put(Items.field_221974_gs, SHULKER_BOX);
        WATER.put(Items.field_221984_gx, SHULKER_BOX);
        WATER.put(Items.field_221887_gB, SHULKER_BOX);
        WATER.put(Items.field_221895_gF, SHULKER_BOX);
        WATER.put(Items.field_221980_gv, SHULKER_BOX);
        LAVA.put(Items.field_151133_ar, (state, worldIn, pos, playerIn, handIn, stack) -> CauldronInteraction.fillBucket(state, worldIn, pos, playerIn, handIn, stack, new ItemStack((IItemProvider)Items.field_151129_at), blockstate -> true, SoundEvents.field_187633_N));
        LAVA.put(Items.field_151131_as, FILL_WATER);
        LAVA.put((Item)CCBItems.POWDER_SNOW_BUCKET.get(), FILL_POWDER_SNOW);
        POWDER_SNOW.put(Items.field_151133_ar, (state, worldIn, pos, playerIn, handIn, stack) -> CauldronInteraction.fillBucket(state, worldIn, pos, playerIn, handIn, stack, new ItemStack((IItemProvider)CCBItems.POWDER_SNOW_BUCKET.get()), blockstate -> (Integer)blockstate.func_177229_b((Property)LayeredCauldronBlock.FLUID_LEVEL) == 3, (SoundEvent)CCBSoundEvents.ITEM_BUCKET_FILL_POWDER_SNOW.get()));
        POWDER_SNOW.put(Items.field_151131_as, FILL_WATER);
        POWDER_SNOW.put(Items.field_151129_at, FILL_LAVA);
    }

    public static ActionResultType fillBucket(BlockState state, World world, BlockPos pos, PlayerEntity playerIn, Hand handIn, ItemStack empty, ItemStack filled, Predicate<BlockState> predicate, SoundEvent soundEvent) {
        if (!predicate.test(state)) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            playerIn.func_184611_a(handIn, ItemUtils.createFilledResult(empty, playerIn, filled));
            playerIn.func_195066_a(Stats.field_188078_L);
            world.func_175656_a(pos, Blocks.field_150383_bp.func_176223_P());
            world.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    public static ActionResultType emptyBucket(World world, BlockPos pos, PlayerEntity playerIn, Hand handIn, ItemStack stack, BlockState state, SoundEvent soundEvent) {
        if (!world.field_72995_K) {
            playerIn.func_184611_a(handIn, ItemUtils.createFilledResult(stack, playerIn, new ItemStack((IItemProvider)Items.field_151133_ar)));
            playerIn.func_195066_a(Stats.field_188077_K);
            world.func_175656_a(pos, state);
            world.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }
}

