/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils;

import com.blackgear.cavesandcliffs.common.gameevent.PositionSource;
import com.blackgear.cavesandcliffs.common.gameevent.PositionSourceType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class Vibration {
    public static final Codec<Vibration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.field_239578_a_.fieldOf("origin").forGetter(vibration -> vibration.origin), (App)PositionSource.CODEC.fieldOf("destination").forGetter(vibration -> vibration.destination), (App)Codec.INT.fieldOf("arrival_in_ticks").forGetter(vibration -> vibration.arrivalInTicks)).apply((Applicative)instance, Vibration::new));
    private final BlockPos origin;
    private final PositionSource destination;
    private final int arrivalInTicks;

    public Vibration(BlockPos origin, PositionSource destination, int arrivalInTicks) {
        this.origin = origin;
        this.destination = destination;
        this.arrivalInTicks = arrivalInTicks;
    }

    public int getArrivalInTicks() {
        return this.arrivalInTicks;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public PositionSource getDestination() {
        return this.destination;
    }

    public static Vibration readFromBuffer(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        PositionSource source = PositionSourceType.fromNetwork(buffer);
        int ticks = buffer.func_150792_a();
        return new Vibration(pos, source, ticks);
    }

    public static void writeFromBuffer(PacketBuffer buffer, Vibration vibration) {
        buffer.func_179255_a(vibration.origin);
        PositionSourceType.toNetwork(vibration.destination, buffer);
        buffer.func_150787_b(vibration.arrivalInTicks);
    }
}

