/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils.math;

import com.blackgear.cavesandcliffs.common.utils.math.FloatProvider;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.MathHelper;

public class ClampedNormalFloat
extends FloatProvider {
    public static final Codec<ClampedNormalFloat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(config -> Float.valueOf(config.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(config -> Float.valueOf(config.deviation)), (App)Codec.FLOAT.fieldOf("min").forGetter(config -> Float.valueOf(config.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(config -> Float.valueOf(config.max))).apply((Applicative)instance, ClampedNormalFloat::new)).comapFlatMap(config -> config.max < config.min ? DataResult.error((String)("Max must be larger than min: [" + config.min + ", " + config.max + "]")) : DataResult.success((Object)config), Function.identity());
    private final float mean;
    private final float deviation;
    private final float min;
    private final float max;

    public static ClampedNormalFloat of(float mean, float deviation, float min, float max) {
        return new ClampedNormalFloat(mean, deviation, min, max);
    }

    public ClampedNormalFloat(float mean, float deviation, float min, float max) {
        this.mean = mean;
        this.deviation = deviation;
        this.min = min;
        this.max = max;
    }

    @Override
    public float sample(Random rand) {
        return ClampedNormalFloat.sample(rand, this.mean, this.deviation, this.min, this.max);
    }

    public static float sample(Random rand, float mean, float deviation, float min, float max) {
        return MathHelper.func_76131_a((float)MathUtils.normal(rand, mean, deviation), (float)min, (float)max);
    }

    @Override
    public float getMinValue() {
        return this.min;
    }

    @Override
    public float getMaxValue() {
        return this.max;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            ClampedNormalFloat clampedNormalFloat = (ClampedNormalFloat)object;
            return this.mean == clampedNormalFloat.mean && this.deviation == clampedNormalFloat.deviation && this.min == clampedNormalFloat.min && this.max == clampedNormalFloat.max;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mean), Float.valueOf(this.deviation), Float.valueOf(this.min), Float.valueOf(this.max));
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.min + '-' + this.max + ']';
    }
}

