/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils.math;

import com.blackgear.cavesandcliffs.common.utils.math.FloatProvider;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class UniformFloat
extends FloatProvider {
    public static final Codec<UniformFloat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(config -> Float.valueOf(config.minInclusive)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(config -> Float.valueOf(config.maxExclusive))).apply((Applicative)instance, UniformFloat::new)).comapFlatMap(config -> config.maxExclusive < config.minInclusive ? DataResult.error((String)("Max must be at least min, min_inclusive: " + config.minInclusive + ", max_inclusive: " + config.maxExclusive)) : DataResult.success((Object)config), Function.identity());
    private final float minInclusive;
    private final float maxExclusive;

    private UniformFloat(float minInclusive, float maxExclusive) {
        this.minInclusive = minInclusive;
        this.maxExclusive = maxExclusive;
    }

    public static UniformFloat of(float minInclusive, float maxExclusive) {
        if (maxExclusive <= minInclusive) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(minInclusive, maxExclusive);
    }

    @Override
    public float sample(Random rand) {
        return MathUtils.randomBetween(rand, this.minInclusive, this.maxExclusive);
    }

    @Override
    public float getMinValue() {
        return this.minInclusive;
    }

    @Override
    public float getMaxValue() {
        return this.maxExclusive;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            UniformFloat uniformFloat = (UniformFloat)object;
            return this.minInclusive == uniformFloat.minInclusive && this.maxExclusive == uniformFloat.maxExclusive;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.minInclusive), Float.valueOf(this.maxExclusive));
    }

    public String toString() {
        return "[" + this.minInclusive + '-' + this.maxExclusive + ']';
    }
}

