/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils.math;

import com.blackgear.cavesandcliffs.common.utils.math.IntProvider;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class UniformInt
extends IntProvider {
    public static final Codec<UniformInt> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_inclusive").forGetter(config -> config.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(config -> config.maxInclusive)).apply((Applicative)instance, UniformInt::new)).comapFlatMap(config -> config.maxInclusive < config.minInclusive ? DataResult.error((String)("Max must be at least min, min_inclusive: " + config.minInclusive + ", max_inclusive: " + config.maxInclusive)) : DataResult.success((Object)config), Function.identity());
    private final int minInclusive;
    private final int maxInclusive;

    private UniformInt(int p_i241900_1_, int p_i241900_2_) {
        this.minInclusive = p_i241900_1_;
        this.maxInclusive = p_i241900_2_;
    }

    public static UniformInt fixed(int p_242252_0_) {
        return new UniformInt(p_242252_0_, p_242252_0_);
    }

    public static UniformInt of(int p_242253_0_, int p_242253_1_) {
        return new UniformInt(p_242253_0_, p_242253_1_);
    }

    @Override
    public int sample(Random rand) {
        return MathUtils.randomBetweenInclusive(rand, this.minInclusive, this.maxInclusive);
    }

    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    public boolean equals(Object uniform) {
        if (this == uniform) {
            return true;
        }
        if (uniform != null && this.getClass() == uniform.getClass()) {
            UniformInt uniformInt = (UniformInt)uniform;
            return this.minInclusive == uniformInt.minInclusive && this.maxInclusive == uniformInt.maxInclusive;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.minInclusive, this.maxInclusive);
    }

    public String toString() {
        return "[" + this.minInclusive + '-' + (this.minInclusive + this.maxInclusive) + ']';
    }
}

