/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.IWorldGenerationReader;

public abstract class Column {
    public static Range around(int floor, int ceiling) {
        return new Range(floor - 1, ceiling + 1);
    }

    public static Range inside(int floor, int ceiling) {
        return new Range(floor, ceiling);
    }

    public static Column below(int ceiling) {
        return new Ray(ceiling, false);
    }

    public static Column fromHighest(int height) {
        return new Ray(height + 1, false);
    }

    public static Column above(int floor) {
        return new Ray(floor, true);
    }

    public static Column fromLowest(int height) {
        return new Ray(height - 1, true);
    }

    public static Column line() {
        return Line.INSTANCE;
    }

    public static Column create(OptionalInt floor, OptionalInt ceiling) {
        if (floor.isPresent() && ceiling.isPresent()) {
            return Column.inside(floor.getAsInt(), ceiling.getAsInt());
        }
        if (floor.isPresent()) {
            return Column.above(floor.getAsInt());
        }
        return ceiling.isPresent() ? Column.below(ceiling.getAsInt()) : Column.line();
    }

    public abstract OptionalInt getCeiling();

    public abstract OptionalInt getFloor();

    public abstract OptionalInt getHeight();

    public Column withFloor(OptionalInt floor) {
        return Column.create(floor, this.getCeiling());
    }

    public static Optional<Column> scan(IWorldGenerationReader worldReader, BlockPos pos, int height, Predicate<BlockState> canGenerate, Predicate<BlockState> canReplace) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        if (!worldReader.func_217375_a(pos, canGenerate)) {
            return Optional.empty();
        }
        int y = pos.func_177956_o();
        OptionalInt ceiling = Column.scanDirection(worldReader, height, canGenerate, canReplace, mutable, y, Direction.UP);
        OptionalInt floor = Column.scanDirection(worldReader, height, canGenerate, canReplace, mutable, y, Direction.DOWN);
        return Optional.of(Column.create(floor, ceiling));
    }

    private static OptionalInt scanDirection(IWorldGenerationReader worldIn, int height, Predicate<BlockState> canGenerate, Predicate<BlockState> canReplace, BlockPos.Mutable pos, int y, Direction direction) {
        pos.func_185336_p(y);
        for (int index = 1; index < height && worldIn.func_217375_a((BlockPos)pos, canGenerate); ++index) {
            pos.func_189536_c(direction);
        }
        return worldIn.func_217375_a((BlockPos)pos, canReplace) ? OptionalInt.of(pos.func_177956_o()) : OptionalInt.empty();
    }

    public static final class Range
    extends Column {
        private final int floor;
        private final int ceiling;

        protected Range(int floor, int ceiling) {
            this.floor = floor;
            this.ceiling = ceiling;
            if (this.height() < 0) {
                throw new IllegalArgumentException("Column of negative height: " + this);
            }
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.of(this.ceiling);
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.of(this.floor);
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.of(this.height());
        }

        public int ceiling() {
            return this.ceiling;
        }

        public int floor() {
            return this.floor;
        }

        public int height() {
            return this.ceiling - this.floor - 1;
        }

        public String toString() {
            return "C(" + this.ceiling + "-" + this.floor + ')';
        }
    }

    public static final class Line
    extends Column {
        private static final Line INSTANCE = new Line();

        private Line() {
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return "C(-)";
        }
    }

    public static final class Ray
    extends Column {
        private final int edge;
        private final boolean pointingUp;

        public Ray(int edge, boolean pointingUp) {
            this.edge = edge;
            this.pointingUp = pointingUp;
        }

        @Override
        public OptionalInt getCeiling() {
            return this.pointingUp ? OptionalInt.empty() : OptionalInt.of(this.edge);
        }

        @Override
        public OptionalInt getFloor() {
            return this.pointingUp ? OptionalInt.of(this.edge) : OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return this.pointingUp ? "C(" + this.edge + "-)" : "C(-" + this.edge + ")";
        }
    }
}

