/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.blackgear.cavesandcliffs.common.world.gen.OctavesNoiseGen;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.util.SharedSeedRandom;

public class MaxMinNoiseMixer {
    private final double valueFactor;
    private final OctavesNoiseGen firstSampler;
    private final OctavesNoiseGen secondSampler;

    public static MaxMinNoiseMixer create(SharedSeedRandom random, int octaves, double ... doubles) {
        return new MaxMinNoiseMixer(random, octaves, (DoubleList)new DoubleArrayList(doubles));
    }

    public static MaxMinNoiseMixer create(SharedSeedRandom random, int octaves, DoubleList doubleList) {
        return new MaxMinNoiseMixer(random, octaves, doubleList);
    }

    public MaxMinNoiseMixer(SharedSeedRandom random, int octaves, DoubleList doubleList) {
        this.firstSampler = OctavesNoiseGen.create(random, octaves, doubleList);
        this.secondSampler = OctavesNoiseGen.create(random, octaves, doubleList);
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        this.valueFactor = 0.16666666666666666 / this.createAmplitude(max - min);
    }

    private double createAmplitude(int octaves) {
        return 0.1 * (1.0 + 1.0 / (double)(octaves + 1));
    }

    public double getValue(double xIn, double yIn, double zIn) {
        double x = xIn * 1.0181268882175227;
        double y = yIn * 1.0181268882175227;
        double z = zIn * 1.0181268882175227;
        return (this.firstSampler.getValue(xIn, yIn, zIn) + this.secondSampler.getValue(x, y, z)) * this.valueFactor;
    }
}

