/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.blackgear.bgcore.core.api.FeaturePlacement;
import com.blackgear.cavesandcliffs.common.world.gen.ConfiguredBiomeFeatures;
import com.blackgear.cavesandcliffs.core.CCBConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityTypes;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;

public class VanillaBiomeFeatures {
    public static void addDefaultUndergroundVariety(BiomeGenerationSettings.Builder builder) {
        if (((Boolean)CCBConfig.doesTuffGenerate.get()).booleanValue()) {
            FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.ORE_TUFF);
        }
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.GLOW_LICHEN);
        if (((Boolean)CCBConfig.doesDeepslateGenerate.get()).booleanValue()) {
            FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.ORE_DEEPSLATE);
        }
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.RARE_DRIPSTONE_CLUSTER_FEATURE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.RARE_SMALL_DRIPSTONE_FEATURE);
    }

    public static void addDripstone(BiomeGenerationSettings.Builder builder) {
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.LARGE_DRIPSTONE_FEATURE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.DRIPSTONE_CLUSTER_FEATURE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.SMALL_DRIPSTONE_FEATURE);
    }

    public static void addDefaultCrystalFormations(BiomeGenerationSettings.Builder builder) {
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ConfiguredBiomeFeatures.AMETHYST_GEODE);
    }

    public static void addMountainSpawns(MobSpawnInfo.Builder builder) {
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.CREATURE, (EntityType)((EntityType)CCBEntityTypes.GOAT.get()), (int)10, (int)4, (int)6);
    }

    public static void addCaveSpawns(MobSpawnInfo.Builder builder) {
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.AMBIENT, (EntityType)EntityType.field_200791_e, (int)10, (int)8, (int)8);
        VanillaBiomeFeatures.addCaveWaterSpawns(builder);
    }

    public static void addCommonSpawns(MobSpawnInfo.Builder builder) {
        VanillaBiomeFeatures.addCaveSpawns(builder);
        VanillaBiomeFeatures.addMonsters(builder, 95, 5, 100);
    }

    public static void addCaveWaterSpawns(MobSpawnInfo.Builder builder) {
        if (((Boolean)CCBConfig.doGlowsquidsSpawn.get()).booleanValue()) {
            FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)CCBEntityTypes.UNDERGROUND_WATER_CREATURE, (EntityType)((EntityType)CCBEntityTypes.GLOW_SQUID.get()), (int)10, (int)4, (int)6);
        }
    }

    public static void addMonsters(MobSpawnInfo.Builder builder, int zombieWeight, int zombieVillagerWeight, int skeletonWeight) {
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200748_an, (int)100, (int)4, (int)4);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200725_aD, (int)zombieWeight, (int)4, (int)4);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200727_aF, (int)zombieVillagerWeight, (int)1, (int)1);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200741_ag, (int)skeletonWeight, (int)4, (int)4);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200797_k, (int)100, (int)4, (int)4);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200743_ai, (int)100, (int)4, (int)4);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200803_q, (int)100, (int)1, (int)4);
        FeaturePlacement.addSpawn((MobSpawnInfo.Builder)builder, (EntityClassification)EntityClassification.MONSTER, (EntityType)EntityType.field_200759_ay, (int)5, (int)1, (int)1);
    }

    public static void addLushCavesVegetationFeatures(BiomeGenerationSettings.Builder builder) {
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.LUSH_CAVES_CEILING_VEGETATION);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.CAVE_VINES);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.LUSH_CAVES_CLAY);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.LUSH_CAVE_VEGETATION);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.ROOTED_AZALEA_TREES);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.SPORE_BLOSSOM_FEATURE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredBiomeFeatures.CLASSIC_VINES_CAVE_FEATURE);
    }

    public static void addLushCavesSpecialOres(BiomeGenerationSettings.Builder builder) {
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.ORE_CLAY);
    }

    public static void generateDeepslate(BiomeGenerationSettings.Builder builder) {
        if ((Integer)CCBConfig.deepslateLayerMaxHeight.get() != 0) {
            FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredBiomeFeatures.DEEPSLATE_FEATURE);
        }
        VanillaBiomeFeatures.addDeepslateOres(builder);
    }

    public static void addDeepslateOres(BiomeGenerationSettings.Builder builder) {
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_COAL_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_IRON_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_GOLD_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_REDSTONE_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_DIAMOND_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_LAPIS_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_TUFF_ORE);
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.INFESTED_DEEPSLATE);
    }

    public static void addDeepslateEmerald(BiomeGenerationSettings.Builder builder) {
        FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_EMERALD_ORE);
    }

    public static void addCopperOre(BiomeGenerationSettings.Builder builder) {
        if (((Boolean)CCBConfig.doesCopperGenerate.get()).booleanValue()) {
            FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.ORE_COPPER);
            FeaturePlacement.addFeature((BiomeGenerationSettings.Builder)builder, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredBiomeFeatures.DEEPSLATE_COPPER_ORE);
        }
    }
}

