/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.world.gen.features.DripstoneUtils;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.SmallDripstoneConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class SmallDripstoneFeature
extends Feature<SmallDripstoneConfig> {
    public SmallDripstoneFeature(Codec<SmallDripstoneConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, SmallDripstoneConfig config) {
        if (!DripstoneUtils.isEmptyOrWater((IWorld)worldIn, pos)) {
            return false;
        }
        int placements = MathUtils.randomBetweenInclusive(rand, 1, config.maxPlacements);
        boolean shouldPlace = false;
        for (int index = 0; index < placements; ++index) {
            BlockPos offset = SmallDripstoneFeature.randomOffset(rand, pos, config);
            if (!SmallDripstoneFeature.searchAndTryToPlaceDripstone((IWorld)worldIn, rand, offset, config)) continue;
            shouldPlace = true;
        }
        return shouldPlace;
    }

    private static boolean searchAndTryToPlaceDripstone(IWorld worldIn, Random rand, BlockPos pos, SmallDripstoneConfig config) {
        Direction randomDirection = Direction.func_239631_a_((Random)rand);
        Direction facingVertically = rand.nextBoolean() ? Direction.UP : Direction.DOWN;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int index = 0; index < config.emptySpaceSearchRadius; ++index) {
            if (!DripstoneUtils.isEmptyOrWater(worldIn, (BlockPos)mutable)) {
                return false;
            }
            if (SmallDripstoneFeature.tryToPlaceDripstone(worldIn, rand, (BlockPos)mutable, facingVertically, config)) {
                return true;
            }
            if (SmallDripstoneFeature.tryToPlaceDripstone(worldIn, rand, (BlockPos)mutable, facingVertically.func_176734_d(), config)) {
                return true;
            }
            mutable.func_189536_c(randomDirection);
        }
        return false;
    }

    private static boolean tryToPlaceDripstone(IWorld worldIn, Random rand, BlockPos pos, Direction direction, SmallDripstoneConfig config) {
        if (!DripstoneUtils.isEmptyOrWater(worldIn, pos)) {
            return false;
        }
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState state = worldIn.func_180495_p(blockPos);
        if (!DripstoneUtils.isDripstoneBase(state)) {
            return false;
        }
        SmallDripstoneFeature.createPatchOfDripstoneBlocks(worldIn, rand, blockPos);
        int integer8 = rand.nextFloat() < config.chanceOfTallerDripstone && DripstoneUtils.isEmptyOrWater(worldIn, pos.func_177972_a(direction)) ? 2 : 1;
        DripstoneUtils.growPointedDripstone(worldIn, pos, direction, integer8, false);
        return true;
    }

    private static void createPatchOfDripstoneBlocks(IWorld worldIn, Random rand, BlockPos pos) {
        DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(rand.nextFloat() >= 0.3f)) continue;
            BlockPos firstPos = pos.func_177972_a(direction);
            DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, firstPos);
            if (rand.nextBoolean()) continue;
            BlockPos secondPos = firstPos.func_177972_a(Direction.func_239631_a_((Random)rand));
            DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, secondPos);
            if (rand.nextBoolean()) continue;
            BlockPos thirdPos = secondPos.func_177972_a(Direction.func_239631_a_((Random)rand));
            DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, thirdPos);
        }
    }

    private static BlockPos randomOffset(Random rand, BlockPos pos, SmallDripstoneConfig config) {
        return pos.func_177982_a(MathUtils.randomBetweenInclusive(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), MathUtils.randomBetweenInclusive(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), MathUtils.randomBetweenInclusive(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin));
    }
}

