/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features.config;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class GlowLichenConfig
implements IFeatureConfig {
    public static final Codec<GlowLichenConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(config -> config.searchRange), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(config -> config.canPlaceOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(config -> config.canPlaceOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(config -> config.canPlaceOnWall), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(config -> Float.valueOf(config.chanceOfSpreading)), (App)BlockState.field_235877_b_.listOf().fieldOf("can_be_placed_on").forGetter(config -> new ArrayList<BlockState>(config.canBePlacedOn))).apply((Applicative)instance, GlowLichenConfig::new));
    public final int searchRange;
    public final boolean canPlaceOnFloor;
    public final boolean canPlaceOnCeiling;
    public final boolean canPlaceOnWall;
    public final float chanceOfSpreading;
    public final List<BlockState> canBePlacedOn;
    public final List<Direction> validDirections;

    public GlowLichenConfig(int searchRange, boolean canPlaceOnFloor, boolean canPlaceOnCeiling, boolean canPlaceOnWall, float chanceOfSpreading, List<BlockState> canBePlacedOn) {
        this.searchRange = searchRange;
        this.canPlaceOnFloor = canPlaceOnFloor;
        this.canPlaceOnCeiling = canPlaceOnCeiling;
        this.canPlaceOnWall = canPlaceOnWall;
        this.chanceOfSpreading = chanceOfSpreading;
        this.canBePlacedOn = canBePlacedOn;
        ArrayList directions = Lists.newArrayList();
        if (canPlaceOnCeiling) {
            directions.add(Direction.UP);
        }
        if (canPlaceOnFloor) {
            directions.add(Direction.DOWN);
        }
        if (canPlaceOnWall) {
            Direction.Plane.HORIZONTAL.forEach(directions::add);
        }
        this.validDirections = Collections.unmodifiableList(directions);
    }

    public boolean canBePlacedOn(Block block) {
        return this.canBePlacedOn.stream().anyMatch(blockx -> blockx.func_177230_c().equals(block));
    }
}

