/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.placement;

import com.blackgear.cavesandcliffs.common.world.gen.Column;
import com.blackgear.cavesandcliffs.common.world.gen.placement.CaveDecoratorConfig;
import com.blackgear.cavesandcliffs.common.world.gen.placement.utils.CaveSurface;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.Placement;

public class CaveSurfacePlacement
extends Placement<CaveDecoratorConfig> {
    public CaveSurfacePlacement(Codec<CaveDecoratorConfig> config) {
        super(config);
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper helper, Random rand, CaveDecoratorConfig config, BlockPos pos) {
        Optional<Column> column = Column.scan((IWorldGenerationReader)helper.field_242889_a, pos, config.floorToCeilingSearchRange, AbstractBlock.AbstractBlockState::func_196958_f, state -> state.func_185904_a().func_76220_a());
        if (!column.isPresent()) {
            return Stream.of(new BlockPos[0]);
        }
        OptionalInt surfaceType = config.surface == CaveSurface.CEILING ? column.get().getCeiling() : column.get().getFloor();
        return !surfaceType.isPresent() ? Stream.of(new BlockPos[0]) : Stream.of(BlockPosUtils.atY(pos, surfaceType.getAsInt() - config.surface.getY()));
    }
}

