/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeightedRandom {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int getTotalWeight(List<? extends Item> list) {
        long weight = 0L;
        for (Item item : list) {
            weight += (long)item.itemWeight;
        }
        if (weight > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)weight;
    }

    public static <T extends Item> Optional<T> getRandomItem(Random random, List<T> collection, int totalWeight) {
        if (totalWeight < 0) {
            throw (IllegalArgumentException)Util.func_229757_c_((Throwable)new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int weight = random.nextInt(totalWeight);
        return WeightedRandom.getAt(collection, weight);
    }

    public static <T extends Item> Optional<T> getAt(List<T> collection, int weight) {
        Item item;
        Iterator<T> collectionIterator = collection.iterator();
        do {
            if (!collectionIterator.hasNext()) {
                return Optional.empty();
            }
            item = (Item)collectionIterator.next();
        } while ((weight -= item.itemWeight) >= 0);
        return Optional.of(item);
    }

    public static <T extends Item> Optional<T> getRandomItem(Random rand, List<T> collection) {
        return WeightedRandom.getRandomItem(rand, collection, WeightedRandom.getTotalWeight(collection));
    }

    public static class Item {
        public final int itemWeight;

        public Item(int itemWeight) {
            if (itemWeight < 0) {
                throw (IllegalArgumentException)Util.func_229757_c_((Throwable)new IllegalArgumentException("Weight should be >= 0"));
            }
            if (itemWeight == 0 && SharedConstants.field_206244_b) {
                LOGGER.warn("Found 0 weight, make sure this is intentional!");
            }
            this.itemWeight = itemWeight;
        }
    }
}

