/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.desert.obelisk;

import com.yungnickyoung.minecraft.yungsextras.world.feature.AbstractTemplateFeature;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;

@ParametersAreNonnullByDefault
public abstract class AbstractDesertObeliskFeature
extends AbstractTemplateFeature<NoFeatureConfig> {
    private static final String path = "desert/obelisk/";
    protected ResourceLocation name;

    public AbstractDesertObeliskFeature(String name) {
        super(NoFeatureConfig.field_236558_a_);
        this.name = new ResourceLocation("yungsextras", path + name);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        while (world.func_175623_d((BlockPos)mutable) && mutable.func_177956_o() > 2) {
            mutable.func_189536_c(Direction.DOWN);
        }
        BlockPos surfacePos = mutable.func_185334_h();
        BlockPos cornerPos = surfacePos.func_177982_a(-2, 0, -2);
        Block block = world.func_180495_p(surfacePos).func_177230_c();
        if (!BlockTags.field_203436_u.func_230235_a_((Object)block)) {
            return false;
        }
        mutable.func_189533_g((Vector3i)cornerPos);
        if (world.func_175623_d((BlockPos)mutable)) {
            return false;
        }
        mutable.func_189533_g((Vector3i)cornerPos).func_189534_c(Direction.SOUTH, 3);
        if (world.func_175623_d((BlockPos)mutable)) {
            return false;
        }
        mutable.func_189533_g((Vector3i)cornerPos).func_189534_c(Direction.EAST, 3);
        if (world.func_175623_d((BlockPos)mutable)) {
            return false;
        }
        mutable.func_189533_g((Vector3i)cornerPos).func_189534_c(Direction.SOUTH, 3).func_189534_c(Direction.EAST, 3);
        if (world.func_175623_d((BlockPos)mutable)) {
            return false;
        }
        Template template = this.createTemplate(this.name, world, rand, surfacePos.func_177972_a(Direction.UP));
        return template != null;
    }
}

