/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core.other;

import com.minecraftabnormals.abnormals_core.core.registry.LootInjectionRegistry;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.atmospheric.common.data.PassionVineBundleDispenseBehavior;
import com.minecraftabnormals.atmospheric.common.data.PassionVineDispenseBehavior;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.loot.LootTables;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AtmosphericCompat {
    public static void registerCompat() {
        AtmosphericCompat.registerLootInjectors();
        AtmosphericCompat.registerDispenserBehaviors();
        AtmosphericCompat.registerCompostables();
        AtmosphericCompat.registerFlammables();
        AtmosphericCompat.registerCarvers();
    }

    public static void registerLootInjectors() {
        LootInjectionRegistry.LootInjector injector = new LootInjectionRegistry.LootInjector("atmospheric");
        injector.addLootInjection(injector.buildLootPool("ruined_portal", 1, 0), new ResourceLocation[]{LootTables.field_237384_P_});
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.func_199774_a((IItemProvider)((Block)AtmosphericBlocks.PASSION_VINE_BUNDLE.get()).func_199767_j(), (IDispenseItemBehavior)new PassionVineBundleDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((Block)AtmosphericBlocks.PASSION_VINE.get()).func_199767_j(), (IDispenseItemBehavior)new PassionVineDispenseBehavior());
    }

    public static void registerCarvers() {
        ForgeRegistries.WORLD_CARVERS.forEach(carver -> {
            HashSet<IForgeRegistryEntry> allBlocksToCarve = new HashSet<IForgeRegistryEntry>(carver.field_222718_j);
            allBlocksToCarve.add(AtmosphericBlocks.ARID_SAND.get());
            allBlocksToCarve.add(AtmosphericBlocks.ARID_SANDSTONE.get());
            allBlocksToCarve.add(AtmosphericBlocks.RED_ARID_SAND.get());
            allBlocksToCarve.add(AtmosphericBlocks.RED_ARID_SANDSTONE.get());
            carver.field_222718_j = allBlocksToCarve;
        });
    }

    public static void registerCompostables() {
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ROSEWOOD_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ROSEWOOD_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ROSEWOOD_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.MORADO_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.MORADO_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.MORADO_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.FLOWERING_MORADO_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.YELLOW_BLOSSOMS.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.FLOWERING_MORADO_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.WARM_MONKEY_BRUSH.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.HOT_MONKEY_BRUSH.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.PASSION_VINE.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.PASSION_VINE_COIL.get()), (float)0.85f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.PASSION_VINE_BUNDLE.get()), (float)1.0f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.WATER_HYACINTH.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.PASSIONFRUIT.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.YUCCA_FRUIT.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.ROASTED_YUCCA_FRUIT.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.YUCCA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.YUCCA_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.YUCCA_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.YUCCA_FLOWER.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.BARREL_CACTUS.get()), (float)0.5f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.GILIA.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ARID_SPROUTS.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.ALOE_KERNELS.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericItems.ALOE_LEAVES.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ALOE_BUNDLE.get()), (float)1.0f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.KOUSA_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.KOUSA_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.KOUSA_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ASPEN_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ASPEN_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ASPEN_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.GRIMWOOD_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.GRIMWOOD_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.GRIMWOOD_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.YUCCA_BUNDLE.get()), (float)0.85f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get()), (float)0.85f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.PASSIONFRUIT_CRATE.get()), (float)1.0f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.YUCCA_CASK.get()), (float)1.0f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.ROASTED_YUCCA_CASK.get()), (float)1.0f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AtmosphericBlocks.BARREL_CACTUS_BATCH.get()), (float)1.0f);
    }

    public static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.PASSION_VINE.get()), (int)15, (int)100);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.PASSION_VINE_BUNDLE.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.PASSIONFRUIT_CRATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.SHIMMERING_PASSIONFRUIT_CRATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_CASK.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROASTED_YUCCA_CASK.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ARID_SPROUTS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_FLOWER.get()), (int)5, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_BRANCH.get()), (int)5, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()), (int)5, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.BARREL_CACTUS.get()), (int)5, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_ROSEWOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.VERTICAL_ROSEWOOD_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ROSEWOOD_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.FLOWERING_MORADO_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_MORADO_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_MORADO_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.VERTICAL_MORADO_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.FLOWERING_MORADO_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_MORADO_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.MORADO_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.FLOWERING_MORADO_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_YUCCA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_YUCCA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.VERTICAL_YUCCA_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_YUCCA_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.YUCCA_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_KOUSA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_KOUSA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.VERTICAL_KOUSA_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_KOUSA_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.KOUSA_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_ASPEN_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_ASPEN_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.WATCHFUL_ASPEN_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.WATCHFUL_ASPEN_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.VERTICAL_ASPEN_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_ASPEN_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.ASPEN_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_GRIMWOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.VERTICAL_GRIMWOOD_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AtmosphericBlocks.GRIMWOOD_HEDGE.get()), (int)5, (int)20);
    }
}

