/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.dev.vankka.mcdiscordreserializer.minecraft;

import dcshadow.dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dcshadow.dev.vankka.mcdiscordreserializer.renderer.MinecraftRenderer;
import dcshadow.dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import dcshadow.dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import dcshadow.dev.vankka.simpleast.core.TextStyle;
import dcshadow.dev.vankka.simpleast.core.node.Node;
import dcshadow.dev.vankka.simpleast.core.node.StyleNode;
import dcshadow.dev.vankka.simpleast.core.node.TextNode;
import dcshadow.dev.vankka.simpleast.core.parser.Parser;
import dcshadow.dev.vankka.simpleast.core.parser.Rule;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextComponent;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class MinecraftSerializer {
    public static final MinecraftSerializer INSTANCE = new MinecraftSerializer(){

        @Override
        public void setDefaultOptions(MinecraftSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setParser(Parser<Object, Node<Object>, Object> parser) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setRenderer(MinecraftRenderer renderer) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private MinecraftSerializerOptions defaultOptions;
    @Deprecated
    private Parser<Object, Node<Object>, Object> parser;
    @Deprecated
    private MinecraftRenderer renderer;

    public MinecraftSerializer() {
        this(MinecraftSerializerOptions.defaults());
    }

    public MinecraftSerializer(@NonNull MinecraftSerializerOptions defaultOptions) {
        if (defaultOptions == null) {
            throw new NullPointerException("defaultOptions is marked non-null but is null");
        }
        this.defaultOptions = defaultOptions;
    }

    @Deprecated
    public MinecraftSerializer(boolean debugging) {
        this.parser = new Parser(debugging);
        this.renderer = new DefaultMinecraftRenderer();
        this.parser.addRules(DiscordMarkdownRules.createAllRulesForDiscord(true));
    }

    @Deprecated
    public MinecraftSerializer(@NonNull Parser<Object, Node<Object>, Object> parser, @NonNull MinecraftRenderer renderer) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (renderer == null) {
            throw new NullPointerException("renderer is marked non-null but is null");
        }
        this.parser = parser;
        this.renderer = renderer;
    }

    @Deprecated
    public MinecraftSerializer(Parser<Object, Node<Object>, Object> parser, MinecraftRenderer renderer, List<Rule<Object, Node<Object>, Object>> rules) {
        this(parser, renderer);
        parser.addRules(rules);
    }

    @Deprecated
    public Parser<Object, Node<Object>, Object> getParser() {
        return this.parser;
    }

    @Deprecated
    public void setParser(Parser<Object, Node<Object>, Object> parser) {
        this.parser = parser;
    }

    @Deprecated
    public MinecraftRenderer getRenderer() {
        return this.renderer;
    }

    @Deprecated
    public void setRenderer(@NonNull MinecraftRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException("renderer is marked non-null but is null");
        }
        this.renderer = renderer;
    }

    public Component serialize(@NonNull String discordMessage) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        MinecraftSerializerOptions options = this.getDefaultOptions();
        if (this.parser != null) {
            options.withParser(this.parser);
        }
        if (this.renderer != null) {
            options.withRenderer(this.renderer);
        }
        return this.serialize(discordMessage, options);
    }

    @Deprecated
    public Component serialize(@NonNull String discordMessage, boolean debugLogging) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        MinecraftSerializerOptions options = this.getDefaultOptions();
        options = options.withDebuggingEnabled(debugLogging);
        if (this.parser != null) {
            options.withParser(this.parser);
        }
        if (this.renderer != null) {
            options.withRenderer(this.renderer);
        }
        return this.serialize(discordMessage, options);
    }

    public Component serialize(@NonNull String discordMessage, @NonNull MinecraftSerializerOptions serializerOptions) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        if (serializerOptions == null) {
            throw new NullPointerException("serializerOptions is marked non-null but is null");
        }
        ArrayList<Component> components = new ArrayList<Component>();
        List<Node<Object>> nodes = serializerOptions.getParser().parse(discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        for (Node<Object> node : nodes) {
            components.add(this.addChild(node, Component.empty(), serializerOptions));
        }
        return Component.empty().children(components);
    }

    private Component addChild(@NonNull Node<Object> node, @NonNull Component rootComponent, @NonNull MinecraftSerializerOptions serializerOptions) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (rootComponent == null) {
            throw new NullPointerException("rootComponent is marked non-null but is null");
        }
        if (serializerOptions == null) {
            throw new NullPointerException("serializerOptions is marked non-null but is null");
        }
        Component component = Component.empty().mergeStyle(rootComponent);
        if (node instanceof TextNode) {
            component = ((TextComponent)component).content(((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            MinecraftRenderer renderer = serializerOptions.getRenderer();
            for (TextStyle style : styles) {
                switch (style.getType()) {
                    case STRIKETHROUGH: {
                        component = renderer.strikethrough(component);
                        break;
                    }
                    case UNDERLINE: {
                        component = renderer.underline(component);
                        break;
                    }
                    case ITALICS: {
                        component = renderer.italics(component);
                        break;
                    }
                    case BOLD: {
                        component = renderer.bold(component);
                        break;
                    }
                    case CODE_STRING: {
                        component = renderer.codeString(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case CODE_BLOCK: {
                        component = renderer.codeBlock(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case QUOTE: {
                        TextComponent content = Component.empty();
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = (TextComponent)content.append(this.addChild(objectNode, component, serializerOptions));
                        }
                        component = renderer.appendQuote(component, content);
                        break;
                    }
                    case SPOILER: {
                        TextComponent content = Component.empty();
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = (TextComponent)content.append(this.addChild(objectNode, component, serializerOptions));
                        }
                        component = renderer.appendSpoiler(component, content);
                        break;
                    }
                    case MENTION_EMOJI: {
                        component = renderer.appendEmoteMention(component, style.getExtra().get("name"), style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_CHANNEL: {
                        component = renderer.appendChannelMention(component, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_USER: {
                        component = renderer.appendUserMention(component, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_ROLE: {
                        component = renderer.appendRoleMention(component, style.getExtra().get("id"));
                        break;
                    }
                }
            }
        }
        List<Node<Object>> children = node.getChildren();
        if (children != null) {
            for (Node node2 : children) {
                component = component.append(this.addChild(node2, component, serializerOptions));
            }
        }
        return component;
    }

    public MinecraftSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(MinecraftSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }
}

