/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.dev.vankka.mcdiscordreserializer.rules;

import dcshadow.dev.vankka.simpleast.core.TextStyle;
import dcshadow.dev.vankka.simpleast.core.node.Node;
import dcshadow.dev.vankka.simpleast.core.node.StyleNode;
import dcshadow.dev.vankka.simpleast.core.parser.ParseSpec;
import dcshadow.dev.vankka.simpleast.core.parser.Parser;
import dcshadow.dev.vankka.simpleast.core.parser.Rule;
import dcshadow.dev.vankka.simpleast.core.simple.SimpleMarkdownRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiscordMarkdownRules {
    private static final Pattern PATTERN_EMOTE_MENTION = Pattern.compile("^<a?:(\\w+):(\\d+)>$");
    private static final Pattern PATTERN_CHANNEL_MENTION = Pattern.compile("^<#(\\d+)>$");
    private static final Pattern PATTERN_USER_MENTION = Pattern.compile("^<@!?(\\d+)>$");
    private static final Pattern PATTERN_ROLE_MENTION = Pattern.compile("^<@&(\\d+)>$");
    private static final Pattern PATTERN_SPOILER = Pattern.compile("^\\|\\|([\\s\\S]+?)\\|\\|");
    private static final Pattern PATTERN_CODE_STRING = Pattern.compile("^`(.+?)`");
    private static final Pattern PATTERN_CODE_BLOCK = Pattern.compile("^```(?:(\\S+?)[\\n ])?\\n*(?:(.+?))\\n*```");

    private DiscordMarkdownRules() {
    }

    private static <R, S> Rule<R, Node<R>, S> createEmoteMentionRule() {
        return new Rule<R, Node<R>, S>(PATTERN_EMOTE_MENTION){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("name", matcher.group(1));
                extra.put("id", matcher.group(2));
                return ParseSpec.createTerminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.MENTION_EMOJI, extra)))), state);
            }
        };
    }

    private static <R, S> Rule<R, Node<R>, S> createChannelMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_CHANNEL_MENTION, new TextStyle(TextStyle.Type.MENTION_CHANNEL));
    }

    private static <R, S> Rule<R, Node<R>, S> createUserMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_USER_MENTION, new TextStyle(TextStyle.Type.MENTION_USER));
    }

    private static <R, S> Rule<R, Node<R>, S> createRoleMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_ROLE_MENTION, new TextStyle(TextStyle.Type.MENTION_ROLE));
    }

    private static <R, S> Rule<R, Node<R>, S> createSpoilerRule() {
        return new Rule<R, Node<R>, S>(PATTERN_SPOILER){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("content", matcher.group(1));
                return ParseSpec.createTerminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.SPOILER, extra)))), state);
            }
        };
    }

    private static <R, S> Rule<R, Node<R>, S> createCodeStringRule() {
        return new Rule<R, Node<R>, S>(PATTERN_CODE_STRING){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String content = matcher.group();
                return ParseSpec.createTerminal(StyleNode.Companion.createWithText(content.substring(1, content.length() - 1), new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.CODE_STRING)))), state);
            }
        };
    }

    private static <R, S> Rule<R, Node<R>, S> createCodeBlockRule() {
        return new Rule<R, Node<R>, S>(PATTERN_CODE_BLOCK){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("language", matcher.group(1));
                return ParseSpec.createTerminal(StyleNode.Companion.createWithText(matcher.group(2), Collections.singletonList(new TextStyle(TextStyle.Type.CODE_BLOCK, extra))), state);
            }
        };
    }

    private static <R, S> Rule<R, Node<R>, S> createSimpleMentionRule(Pattern pattern, final TextStyle textStyle) {
        return new Rule<R, Node<R>, S>(pattern){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                textStyle.getExtra().put("id", matcher.group(1));
                return ParseSpec.createTerminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(textStyle))), state);
            }
        };
    }

    private static <R, S> List<Rule<R, Node<R>, S>> createMentionRules() {
        ArrayList<Rule<R, Node<R>, S>> rules = new ArrayList<Rule<R, Node<R>, S>>();
        rules.add(DiscordMarkdownRules.createEmoteMentionRule());
        rules.add(DiscordMarkdownRules.createChannelMentionRule());
        rules.add(DiscordMarkdownRules.createUserMentionRule());
        rules.add(DiscordMarkdownRules.createRoleMentionRule());
        return rules;
    }

    private static <R> List<Rule<R, Node<R>, Object>> createStyleRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.add(DiscordMarkdownRules.createCodeBlockRule());
        rules.add(DiscordMarkdownRules.createSpoilerRule());
        rules.add(DiscordMarkdownRules.createCodeStringRule());
        return rules;
    }

    private static <R> List<Rule<R, Node<R>, Object>> createDiscordMarkdownRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.addAll(DiscordMarkdownRules.createMentionRules());
        rules.addAll(DiscordMarkdownRules.createStyleRules());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createAllRulesForDiscord(boolean includeText) {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.addAll(SimpleMarkdownRules.createSimpleMarkdownRules(false));
        rules.addAll(DiscordMarkdownRules.createDiscordMarkdownRules());
        if (includeText) {
            rules.add(SimpleMarkdownRules.createTextRule());
        }
        return rules;
    }

    private static class QuoteState {
        private boolean isInQuote;

        QuoteState(boolean isInQuote) {
            this.isInQuote = isInQuote;
        }

        public QuoteState newQuoteState(boolean isInQuote) {
            this.isInQuote = isInQuote;
            return this;
        }
    }
}

