/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.dev.vankka.simpleast.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TextStyle {
    private final Type type;
    private final Map<String, String> extra = new HashMap<String, String>();

    public TextStyle(Type type) {
        this(type, Collections.emptyMap());
    }

    public TextStyle(Type type, Map<String, String> extra) {
        this.type = type;
        extra.forEach(this.extra::put);
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextStyle)) {
            return false;
        }
        TextStyle other = (TextStyle)obj;
        if (other.getType() != this.type) {
            return false;
        }
        if (other.getExtra().size() != this.extra.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.extra.entrySet()) {
            String otherValue = other.getExtra().get(entry.getKey());
            if (otherValue != null && otherValue.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "TextStyle(" + (Object)((Object)this.type) + ") [" + this.extra + "]";
    }

    public static enum Type {
        BOLD,
        UNDERLINE,
        ITALICS,
        STRIKETHROUGH,
        MENTION_EMOJI,
        MENTION_CHANNEL,
        MENTION_USER,
        MENTION_ROLE,
        SPOILER,
        QUOTE,
        CODE_STRING,
        CODE_BLOCK;

    }
}

