/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.dev.vankka.simpleast.core.util;

import dcshadow.dev.vankka.simpleast.core.node.Node;
import dcshadow.dev.vankka.simpleast.core.util.NodeProcessor;
import java.util.Collection;
import java.util.List;

public class ASTUtils {
    public static void traversePreOrder(Collection<? extends Node> ast, NodeProcessor nodeProcessor) {
        for (Node node : ast) {
            ASTUtils.traversePreOrderSubtree(node, nodeProcessor);
        }
    }

    private static void traversePreOrderSubtree(Node node, NodeProcessor nodeProcessor) {
        nodeProcessor.processNode(node);
        if (node.hasChildren()) {
            List children = node.getChildren();
            for (Node node2 : children) {
                ASTUtils.traversePreOrderSubtree(node2, nodeProcessor);
            }
        }
    }

    public static void traversePostOrder(Collection<? extends Node> ast, NodeProcessor nodeProcessor) {
        for (Node node : ast) {
            ASTUtils.traversePostOrderSubtree(node, nodeProcessor);
        }
    }

    private static void traversePostOrderSubtree(Node node, NodeProcessor nodeProcessor) {
        if (node.hasChildren()) {
            List children = node.getChildren();
            for (Node node2 : children) {
                ASTUtils.traversePostOrderSubtree(node2, nodeProcessor);
            }
        }
        nodeProcessor.processNode(node);
    }
}

