/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.bossbar;

import dcshadow.net.kyori.adventure.bossbar.BossBarImpl;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.ComponentLike;
import dcshadow.net.kyori.adventure.util.Index;
import dcshadow.net.kyori.examination.Examinable;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.jetbrains.annotations.ApiStatus;
import dcshadow.org.jetbrains.annotations.Contract;
import dcshadow.org.jetbrains.annotations.UnmodifiableView;
import java.util.Set;

@ApiStatus.NonExtendable
public interface BossBar
extends Examinable {
    public static final float MIN_PROGRESS = 0.0f;
    public static final float MAX_PROGRESS = 1.0f;
    @Deprecated
    public static final float MIN_PERCENT = 0.0f;
    @Deprecated
    public static final float MAX_PERCENT = 1.0f;

    public static @NonNull BossBar bossBar(@NonNull ComponentLike name, float progress, @NonNull Color color, @NonNull Overlay overlay) {
        BossBarImpl.checkProgress(progress);
        return BossBar.bossBar(name.asComponent(), progress, color, overlay);
    }

    public static @NonNull BossBar bossBar(@NonNull Component name, float progress, @NonNull Color color, @NonNull Overlay overlay) {
        BossBarImpl.checkProgress(progress);
        return new BossBarImpl(name, progress, color, overlay);
    }

    public static @NonNull BossBar bossBar(@NonNull ComponentLike name, float progress, @NonNull Color color, @NonNull Overlay overlay, @NonNull Set<Flag> flags) {
        BossBarImpl.checkProgress(progress);
        return BossBar.bossBar(name.asComponent(), progress, color, overlay, flags);
    }

    public static @NonNull BossBar bossBar(@NonNull Component name, float progress, @NonNull Color color, @NonNull Overlay overlay, @NonNull Set<Flag> flags) {
        BossBarImpl.checkProgress(progress);
        return new BossBarImpl(name, progress, color, overlay, flags);
    }

    public @NonNull Component name();

    @Contract(value="_ -> this")
    default public @NonNull BossBar name(@NonNull ComponentLike name) {
        return this.name(name.asComponent());
    }

    @Contract(value="_ -> this")
    public @NonNull BossBar name(@NonNull Component var1);

    public float progress();

    @Contract(value="_ -> this")
    public @NonNull BossBar progress(float var1);

    @Deprecated
    default public float percent() {
        return this.progress();
    }

    @Deprecated
    @Contract(value="_ -> this")
    default public @NonNull BossBar percent(float progress) {
        return this.progress(progress);
    }

    public @NonNull Color color();

    @Contract(value="_ -> this")
    public @NonNull BossBar color(@NonNull Color var1);

    public @NonNull Overlay overlay();

    @Contract(value="_ -> this")
    public @NonNull BossBar overlay(@NonNull Overlay var1);

    public @NonNull @UnmodifiableView Set<Flag> flags();

    @Contract(value="_ -> this")
    public @NonNull BossBar flags(@NonNull Set<Flag> var1);

    public boolean hasFlag(@NonNull Flag var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar addFlag(@NonNull Flag var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar removeFlag(@NonNull Flag var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar addFlags(Flag ... var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar removeFlags(Flag ... var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar addFlags(@NonNull Iterable<Flag> var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar removeFlags(@NonNull Iterable<Flag> var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar addListener(@NonNull Listener var1);

    @Contract(value="_ -> this")
    public @NonNull BossBar removeListener(@NonNull Listener var1);

    public static enum Color {
        PINK("pink"),
        BLUE("blue"),
        RED("red"),
        GREEN("green"),
        YELLOW("yellow"),
        PURPLE("purple"),
        WHITE("white");

        public static final Index<String, Color> NAMES;
        private final String name;

        private Color(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Color.class, color -> color.name);
        }
    }

    public static enum Overlay {
        PROGRESS("progress"),
        NOTCHED_6("notched_6"),
        NOTCHED_10("notched_10"),
        NOTCHED_12("notched_12"),
        NOTCHED_20("notched_20");

        public static final Index<String, Overlay> NAMES;
        private final String name;

        private Overlay(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Overlay.class, overlay -> overlay.name);
        }
    }

    public static enum Flag {
        DARKEN_SCREEN("darken_screen"),
        PLAY_BOSS_MUSIC("play_boss_music"),
        CREATE_WORLD_FOG("create_world_fog");

        public static final Index<String, Flag> NAMES;
        private final String name;

        private Flag(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Flag.class, flag -> flag.name);
        }
    }

    @ApiStatus.OverrideOnly
    public static interface Listener {
        default public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        }

        default public void bossBarProgressChanged(@NonNull BossBar bar, float oldProgress, float newProgress) {
            this.bossBarPercentChanged(bar, oldProgress, newProgress);
        }

        @Deprecated
        default public void bossBarPercentChanged(@NonNull BossBar bar, float oldProgress, float newProgress) {
        }

        default public void bossBarColorChanged(@NonNull BossBar bar, @NonNull Color oldColor, @NonNull Color newColor) {
        }

        default public void bossBarOverlayChanged(@NonNull BossBar bar, @NonNull Overlay oldOverlay, @NonNull Overlay newOverlay) {
        }

        default public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<Flag> flagsAdded, @NonNull Set<Flag> flagsRemoved) {
        }
    }
}

