/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.inventory;

import dcshadow.net.kyori.adventure.inventory.BookImpl;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.util.Buildable;
import dcshadow.net.kyori.examination.Examinable;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.jetbrains.annotations.ApiStatus;
import dcshadow.org.jetbrains.annotations.Contract;
import dcshadow.org.jetbrains.annotations.Unmodifiable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@ApiStatus.NonExtendable
public interface Book
extends Buildable<Book, Builder>,
Examinable {
    public static @NonNull Book book(@NonNull Component title, @NonNull Component author, @NonNull Collection<Component> pages) {
        return new BookImpl(title, author, new ArrayList<Component>(pages));
    }

    public static @NonNull Book book(@NonNull Component title, @NonNull Component author, Component ... pages) {
        return Book.book(title, author, Arrays.asList(pages));
    }

    public static @NonNull Builder builder() {
        return new BookImpl.BuilderImpl();
    }

    public @NonNull Component title();

    @Contract(value="_ -> new", pure=true)
    public @NonNull Book title(@NonNull Component var1);

    public @NonNull Component author();

    @Contract(value="_ -> new", pure=true)
    public @NonNull Book author(@NonNull Component var1);

    public @NonNull @Unmodifiable List<Component> pages();

    @Contract(value="_ -> new", pure=true)
    default public @NonNull Book pages(Component ... pages) {
        return this.pages(Arrays.asList(pages));
    }

    @Contract(value="_ -> new", pure=true)
    public @NonNull Book pages(@NonNull List<Component> var1);

    @Override
    default public @NonNull Builder toBuilder() {
        return Book.builder().title(this.title()).author(this.author()).pages(this.pages());
    }

    public static interface Builder
    extends Buildable.Builder<Book> {
        @Contract(value="_ -> this")
        public @NonNull Builder title(@NonNull Component var1);

        @Contract(value="_ -> this")
        public @NonNull Builder author(@NonNull Component var1);

        @Contract(value="_ -> this")
        public @NonNull Builder addPage(@NonNull Component var1);

        @Contract(value="_ -> this")
        public @NonNull Builder pages(Component ... var1);

        @Contract(value="_ -> this")
        public @NonNull Builder pages(@NonNull Collection<Component> var1);

        @Override
        public @NonNull Book build();
    }
}

