/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.sound;

import dcshadow.net.kyori.adventure.key.Key;
import dcshadow.net.kyori.adventure.key.Keyed;
import dcshadow.net.kyori.adventure.sound.SoundImpl;
import dcshadow.net.kyori.adventure.util.Index;
import dcshadow.net.kyori.examination.Examinable;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.jetbrains.annotations.ApiStatus;
import java.util.Objects;
import java.util.function.Supplier;

@ApiStatus.NonExtendable
public interface Sound
extends Examinable {
    public static @NonNull Sound sound(final @NonNull Key name, @NonNull Source source2, float volume, float pitch) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(source2, "source");
        return new SoundImpl(source2, volume, pitch){

            @Override
            public @NonNull Key name() {
                return name;
            }
        };
    }

    public static @NonNull Sound sound(@NonNull Type type, @NonNull Source source2, float volume, float pitch) {
        Objects.requireNonNull(type, "type");
        return Sound.sound(type.key(), source2, volume, pitch);
    }

    public static @NonNull Sound sound(final @NonNull Supplier<? extends Type> type, @NonNull Source source2, float volume, float pitch) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(source2, "source");
        return new SoundImpl(source2, volume, pitch){

            @Override
            public @NonNull Key name() {
                return ((Type)type.get()).key();
            }
        };
    }

    public @NonNull Key name();

    public @NonNull Source source();

    public float volume();

    public float pitch();

    public static enum Source {
        MASTER("master"),
        MUSIC("music"),
        RECORD("record"),
        WEATHER("weather"),
        BLOCK("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYER("player"),
        AMBIENT("ambient"),
        VOICE("voice");

        public static final Index<String, Source> NAMES;
        private final String name;

        private Source(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Source.class, source2 -> source2.name);
        }
    }

    public static interface Type
    extends Keyed {
        @Override
        public @NonNull Key key();
    }
}

