/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.sound;

import dcshadow.net.kyori.adventure.sound.Sound;
import dcshadow.net.kyori.adventure.util.ShadyPines;
import dcshadow.net.kyori.examination.ExaminableProperty;
import dcshadow.net.kyori.examination.string.StringExaminer;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.stream.Stream;

abstract class SoundImpl
implements Sound {
    private final Sound.Source source;
    private final float volume;
    private final float pitch;

    SoundImpl(@NonNull Sound.Source source2, float volume, float pitch) {
        this.source = source2;
        this.volume = volume;
        this.pitch = pitch;
    }

    @Override
    public @NonNull Sound.Source source() {
        return this.source;
    }

    @Override
    public float volume() {
        return this.volume;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SoundImpl)) {
            return false;
        }
        SoundImpl that = (SoundImpl)other;
        return this.name().equals(that.name()) && this.source == that.source && ShadyPines.equals(this.volume, that.volume) && ShadyPines.equals(this.pitch, that.pitch);
    }

    public int hashCode() {
        int result = this.name().hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + Float.hashCode(this.volume);
        result = 31 * result + Float.hashCode(this.pitch);
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("name", this.name()), ExaminableProperty.of("source", (Object)this.source), ExaminableProperty.of("volume", this.volume), ExaminableProperty.of("pitch", this.pitch));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }
}

