/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text;

import dcshadow.net.kyori.adventure.text.ComponentLike;
import dcshadow.net.kyori.adventure.text.PatternReplacementResult;
import dcshadow.net.kyori.adventure.text.TextComponent;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.TextReplacementRenderer;
import dcshadow.net.kyori.adventure.util.IntFunction2;
import dcshadow.net.kyori.examination.ExaminableProperty;
import dcshadow.net.kyori.examination.string.StringExaminer;
import dcshadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;

final class TextReplacementConfigImpl
implements TextReplacementConfig {
    private final Pattern matchPattern;
    private final BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
    private final IntFunction2<PatternReplacementResult> continuer;

    TextReplacementConfigImpl(Builder builder) {
        this.matchPattern = builder.matchPattern;
        this.replacement = builder.replacement;
        this.continuer = builder.continuer;
    }

    @Override
    public @NonNull Pattern matchPattern() {
        return this.matchPattern;
    }

    TextReplacementRenderer.State createState() {
        return new TextReplacementRenderer.State(this.matchPattern, this.replacement, this.continuer);
    }

    @Override
    public @NonNull TextReplacementConfig.Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("matchPattern", this.matchPattern), ExaminableProperty.of("replacement", this.replacement), ExaminableProperty.of("continuer", this.continuer));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    static final class Builder
    implements TextReplacementConfig.Builder {
        @MonotonicNonNull Pattern matchPattern;
        @MonotonicNonNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
        IntFunction2<PatternReplacementResult> continuer = (index, replacement) -> PatternReplacementResult.REPLACE;

        Builder() {
        }

        Builder(TextReplacementConfigImpl instance) {
            this.matchPattern = instance.matchPattern;
            this.replacement = instance.replacement;
            this.continuer = instance.continuer;
        }

        @Override
        public @NonNull Builder match(@NonNull Pattern pattern) {
            this.matchPattern = Objects.requireNonNull(pattern, "pattern");
            return this;
        }

        @Override
        public @NonNull Builder condition(@NonNull IntFunction2<PatternReplacementResult> condition) {
            this.continuer = Objects.requireNonNull(condition, "continuation");
            return this;
        }

        @Override
        public @NonNull Builder replacement(@NonNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement) {
            this.replacement = Objects.requireNonNull(replacement, "replacement");
            return this;
        }

        @Override
        public @NonNull TextReplacementConfig build() {
            if (this.matchPattern == null) {
                throw new IllegalStateException("A pattern must be provided to match against");
            }
            if (this.replacement == null) {
                throw new IllegalStateException("A replacement action must be provided");
            }
            return new TextReplacementConfigImpl(this);
        }
    }
}

