/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text;

import dcshadow.net.kyori.adventure.text.AbstractComponent;
import dcshadow.net.kyori.adventure.text.AbstractComponentBuilder;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.ComponentBuilder;
import dcshadow.net.kyori.adventure.text.ComponentLike;
import dcshadow.net.kyori.adventure.text.TranslatableComponent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.examination.ExaminableProperty;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TranslatableComponentImpl
extends AbstractComponent
implements TranslatableComponent {
    private final String key;
    private final List<Component> args;

    TranslatableComponentImpl(@NonNull List<Component> children, @NonNull Style style, @NonNull String key, @NonNull ComponentLike @NonNull [] args2) {
        this(children, style, key, Arrays.asList(args2));
    }

    TranslatableComponentImpl(@NonNull List<? extends ComponentLike> children, @NonNull Style style, @NonNull String key, @NonNull List<? extends ComponentLike> args2) {
        super(children, style);
        this.key = Objects.requireNonNull(key, "key");
        this.args = AbstractComponent.asComponents(args2, true);
    }

    @Override
    public @NonNull String key() {
        return this.key;
    }

    @Override
    public @NonNull TranslatableComponent key(@NonNull String key) {
        if (Objects.equals(this.key, key)) {
            return this;
        }
        return new TranslatableComponentImpl(this.children, this.style, Objects.requireNonNull(key, "key"), this.args);
    }

    @Override
    public @NonNull List<Component> args() {
        return this.args;
    }

    @Override
    public @NonNull TranslatableComponent args(ComponentLike ... args2) {
        return new TranslatableComponentImpl(this.children, this.style, this.key, args2);
    }

    @Override
    public @NonNull TranslatableComponent args(@NonNull List<? extends ComponentLike> args2) {
        return new TranslatableComponentImpl(this.children, this.style, this.key, args2);
    }

    @Override
    public @NonNull TranslatableComponent children(@NonNull List<? extends ComponentLike> children) {
        return new TranslatableComponentImpl(children, this.style, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent style(@NonNull Style style) {
        return new TranslatableComponentImpl(this.children, style, this.key, this.args);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TranslatableComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TranslatableComponent that = (TranslatableComponent)other;
        return Objects.equals(this.key, that.key()) && Objects.equals(this.args, that.args());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.args.hashCode();
        return result;
    }

    @Override
    protected @NonNull Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.concat(Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("args", this.args)), super.examinablePropertiesWithoutChildren());
    }

    @Override
    public @NonNull TranslatableComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TranslatableComponent, TranslatableComponent.Builder>
    implements TranslatableComponent.Builder {
        private @Nullable String key;
        private List<? extends Component> args = Collections.emptyList();

        BuilderImpl() {
        }

        BuilderImpl(@NonNull TranslatableComponent component) {
            super(component);
            this.key = component.key();
            this.args = component.args();
        }

        @Override
        public @NonNull TranslatableComponent.Builder key(@NonNull String key) {
            this.key = key;
            return this;
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(@NonNull ComponentBuilder<?, ?> arg) {
            return this.args(Collections.singletonList(arg.build()));
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(ComponentBuilder<?, ?> ... args2) {
            if (args2.length == 0) {
                return this.args(Collections.emptyList());
            }
            return this.args(Stream.of(args2).map(ComponentBuilder::build).collect(Collectors.toList()));
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(@NonNull Component arg) {
            return this.args(Collections.singletonList(arg));
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(ComponentLike ... args2) {
            if (args2.length == 0) {
                return this.args(Collections.emptyList());
            }
            return this.args(Arrays.asList(args2));
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(@NonNull List<? extends ComponentLike> args2) {
            this.args = AbstractComponent.asComponents(args2, true);
            return this;
        }

        @Override
        public @NonNull TranslatableComponentImpl build() {
            if (this.key == null) {
                throw new IllegalStateException("key must be set");
            }
            return new TranslatableComponentImpl(this.children, this.buildStyle(), this.key, this.args);
        }
    }
}

