/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text.format;

import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.StyleBuilderApplicable;
import dcshadow.net.kyori.adventure.text.format.TextFormat;
import dcshadow.net.kyori.adventure.util.Index;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name) {
        this.name = name;
    }

    @Override
    public void styleApply(@NonNull Style.Builder style) {
        style.decorate(this);
    }

    public @NonNull String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, constant -> constant.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static @NonNull State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        public static @NonNull State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }
    }
}

