/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text.serializer.gson;

import dcshadow.com.google.gson.Gson;
import dcshadow.com.google.gson.GsonBuilder;
import dcshadow.com.google.gson.JsonElement;
import dcshadow.net.kyori.adventure.key.Key;
import dcshadow.net.kyori.adventure.text.BlockNBTComponent;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.format.TextDecoration;
import dcshadow.net.kyori.adventure.text.serializer.gson.BlockNBTComponentPosSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.IndexedSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.KeySerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.ShowEntitySerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.ShowItemSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.StyleSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.TextColorSerializer;
import dcshadow.net.kyori.adventure.text.serializer.gson.TextColorWrapper;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.function.UnaryOperator;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    static final GsonComponentSerializer INSTANCE = new GsonComponentSerializerImpl(false, null, false);
    static final GsonComponentSerializer LEGACY_INSTANCE = new GsonComponentSerializerImpl(true, null, true);
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final boolean downsampleColor;
    private final @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
    private final boolean emitLegacyHover;

    GsonComponentSerializerImpl(boolean downsampleColor, @Nullable LegacyHoverEventSerializer legacyHoverSerializer, boolean emitLegacyHover) {
        this.downsampleColor = downsampleColor;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.emitLegacyHover = emitLegacyHover;
        this.populator = builder -> {
            builder.registerTypeHierarchyAdapter(Key.class, KeySerializer.INSTANCE);
            builder.registerTypeHierarchyAdapter(Component.class, new ComponentSerializerImpl());
            builder.registerTypeHierarchyAdapter(Style.class, new StyleSerializer(legacyHoverSerializer, emitLegacyHover));
            builder.registerTypeAdapter((Type)((Object)ClickEvent.Action.class), IndexedSerializer.of("click action", ClickEvent.Action.NAMES));
            builder.registerTypeAdapter((Type)((Object)HoverEvent.Action.class), IndexedSerializer.of("hover action", HoverEvent.Action.NAMES));
            builder.registerTypeAdapter((Type)((Object)HoverEvent.ShowItem.class), new ShowItemSerializer());
            builder.registerTypeAdapter((Type)((Object)HoverEvent.ShowEntity.class), new ShowEntitySerializer());
            builder.registerTypeAdapter((Type)((Object)TextColorWrapper.class), new TextColorWrapper.Serializer());
            builder.registerTypeHierarchyAdapter(TextColor.class, downsampleColor ? TextColorSerializer.DOWNSAMPLE_COLOR : TextColorSerializer.INSTANCE);
            builder.registerTypeAdapter((Type)((Object)TextDecoration.class), IndexedSerializer.of("text decoration", TextDecoration.NAMES));
            builder.registerTypeHierarchyAdapter(BlockNBTComponent.Pos.class, BlockNBTComponentPosSerializer.INSTANCE);
            return builder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder())).create();
    }

    @Override
    public @NonNull Gson serializer() {
        return this.serializer;
    }

    @Override
    public @NonNull UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        Component component = this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(string);
        }
        return component;
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return this.serializer().toJson(component);
    }

    @Override
    public @NonNull Component deserializeFromTree(@NonNull JsonElement input) {
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(input);
        }
        return component;
    }

    @Override
    public @NonNull JsonElement serializeToTree(@NonNull Component component) {
        return this.serializer().toJsonTree(component);
    }

    @Override
    public @NonNull GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private boolean downsampleColor = false;
        private @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
        private boolean emitLegacyHover = false;

        BuilderImpl() {
        }

        BuilderImpl(GsonComponentSerializerImpl serializer) {
            this.downsampleColor = serializer.downsampleColor;
            this.emitLegacyHover = serializer.emitLegacyHover;
            this.legacyHoverSerializer = serializer.legacyHoverSerializer;
        }

        @Override
        public @NonNull GsonComponentSerializer.Builder downsampleColors() {
            this.downsampleColor = true;
            return this;
        }

        @Override
        public @NonNull GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer serializer) {
            this.legacyHoverSerializer = serializer;
            return this;
        }

        @Override
        public @NonNull GsonComponentSerializer.Builder emitLegacyHoverEvent() {
            this.emitLegacyHover = true;
            return this;
        }

        @Override
        public @NonNull GsonComponentSerializer build() {
            if (this.legacyHoverSerializer == null) {
                return this.downsampleColor ? LEGACY_INSTANCE : INSTANCE;
            }
            return new GsonComponentSerializerImpl(this.downsampleColor, this.legacyHoverSerializer, this.emitLegacyHover);
        }
    }
}

