/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text.serializer.gson;

import dcshadow.com.google.gson.JsonDeserializationContext;
import dcshadow.com.google.gson.JsonDeserializer;
import dcshadow.com.google.gson.JsonElement;
import dcshadow.com.google.gson.JsonObject;
import dcshadow.com.google.gson.JsonParseException;
import dcshadow.com.google.gson.JsonSerializationContext;
import dcshadow.com.google.gson.JsonSerializer;
import dcshadow.net.kyori.adventure.key.Key;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.UUID;

final class ShowEntitySerializer
implements JsonDeserializer<HoverEvent.ShowEntity>,
JsonSerializer<HoverEvent.ShowEntity> {
    static final String TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";

    ShowEntitySerializer() {
    }

    @Override
    public HoverEvent.ShowEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        if (!object.has(TYPE) || !object.has(ID)) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        Key type = (Key)context.deserialize(object.getAsJsonPrimitive(TYPE), (Type)((Object)Key.class));
        UUID id = UUID.fromString(object.getAsJsonPrimitive(ID).getAsString());
        Component name = null;
        if (object.has(NAME)) {
            name = (Component)context.deserialize(object.get(NAME), (Type)((Object)Component.class));
        }
        return HoverEvent.ShowEntity.of(type, id, name);
    }

    @Override
    public JsonElement serialize(HoverEvent.ShowEntity src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add(TYPE, context.serialize(src.type()));
        json.addProperty(ID, src.id().toString());
        @Nullable Component name = src.name();
        if (name != null) {
            json.add(NAME, context.serialize(name));
        }
        return json;
    }
}

