/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text.serializer.gson;

import dcshadow.com.google.gson.JsonParseException;
import dcshadow.com.google.gson.JsonSyntaxException;
import dcshadow.com.google.gson.TypeAdapter;
import dcshadow.com.google.gson.stream.JsonReader;
import dcshadow.com.google.gson.stream.JsonWriter;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.format.TextDecoration;
import dcshadow.net.kyori.adventure.text.serializer.gson.TextColorSerializer;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.IOException;

final class TextColorWrapper {
    final @Nullable TextColor color;
    final @Nullable TextDecoration decoration;
    final boolean reset;

    TextColorWrapper(@Nullable TextColor color, @Nullable TextDecoration decoration, boolean reset) {
        this.color = color;
        this.decoration = decoration;
        this.reset = reset;
    }

    static class Serializer
    extends TypeAdapter<TextColorWrapper> {
        Serializer() {
        }

        @Override
        public void write(JsonWriter out, TextColorWrapper value) {
            throw new JsonSyntaxException("Cannot write TextColorWrapper instances");
        }

        @Override
        public TextColorWrapper read(JsonReader in) throws IOException {
            boolean reset;
            String input = in.nextString();
            TextColor color = TextColorSerializer.fromString(input);
            TextDecoration decoration = TextDecoration.NAMES.value(input);
            boolean bl = reset = decoration == null && input.equals("reset");
            if (color == null && decoration == null && !reset) {
                throw new JsonParseException("Don't know how to parse " + input + " at " + in.getPath());
            }
            return new TextColorWrapper(color, decoration, reset);
        }
    }
}

