/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.util;

import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.checker.nullness.qual.Nullable;
import dcshadow.org.jetbrains.annotations.Contract;
import java.util.function.Consumer;

public interface Buildable<R, B extends Builder<R>> {
    @Contract(mutates="param1")
    public static <R extends Buildable<R, B>, B extends Builder<R>> @NonNull R configureAndBuild(@NonNull B builder, @Nullable Consumer<? super B> consumer) {
        if (consumer != null) {
            consumer.accept(builder);
        }
        return (R)((Buildable)builder.build());
    }

    @Contract(value="-> new", pure=true)
    public @NonNull B toBuilder();

    public static interface Builder<R> {
        @Contract(value="-> new", pure=true)
        public @NonNull R build();
    }
}

