/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.util;

import dcshadow.net.kyori.adventure.util.HSVLikeImpl;
import dcshadow.net.kyori.examination.Examinable;
import dcshadow.net.kyori.examination.ExaminableProperty;
import dcshadow.org.checkerframework.checker.nullness.qual.NonNull;
import dcshadow.org.checkerframework.common.value.qual.IntRange;
import java.util.stream.Stream;

public interface HSVLike
extends Examinable {
    public static @NonNull HSVLike of(float h, float s, float v) {
        return new HSVLikeImpl(h, s, v);
    }

    public static @NonNull HSVLike fromRGB(@IntRange(from=0L, to=255L) int red, @IntRange(from=0L, to=255L) int green, @IntRange(from=0L, to=255L) int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float delta = max - min;
        float s = max != 0.0f ? delta / max : 0.0f;
        if (s == 0.0f) {
            return new HSVLikeImpl(0.0f, s, max);
        }
        float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        return new HSVLikeImpl(h / 360.0f, s, max);
    }

    public float h();

    public float s();

    public float v();

    @Override
    default public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("h", this.h()), ExaminableProperty.of("s", this.s()), ExaminableProperty.of("v", this.v()));
    }
}

