/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common;

import dcshadow.club.minnced.discord.webhook.WebhookClient;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import dcshadow.javax.annotation.Nonnull;
import dcshadow.javax.annotation.Nullable;
import dcshadow.org.apache.commons.collections4.KeyValue;
import dcshadow.org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import de.erdbeerbaerlp.dcintegration.common.DiscordEventListener;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.api.DiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerSettings;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.ServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.internal.utils.PermissionUtil;

public class Discord
extends Thread {
    private static final File IGNORED_PLAYERS = new File(Variables.discordDataDir, ".PlayerIgnores");
    public static final UUID dummyUUID = new UUID(0L, 0L);
    public final ServerInterface srv;
    private final HashMap<String, UUID> recentMessages = new HashMap(150);
    public final ArrayList<UUID> ignoringPlayers = new ArrayList();
    public final HashMap<Integer, KeyValue<Instant, UUID>> pendingLinks = new HashMap();
    public final HashMap<Integer, KeyValue<Instant, UUID>> pendingBedrockLinks = new HashMap();
    final ArrayList<DiscordEventHandler> eventHandlers = new ArrayList();
    private final HashMap<String, ArrayList<String>> messages = new HashMap();
    private final HashMap<String, Webhook> webhookHashMap = new HashMap();
    private final HashMap<String, WebhookClient> webhookClis = new HashMap();
    private JDA jda = null;
    private Thread messageSender;
    private Thread statusUpdater;
    private DiscordEventListener listener;
    private final HashMap<String, TextChannel> channelCache = new HashMap();

    public Discord(@Nonnull ServerInterface srv) {
        this.srv = srv;
        this.setDaemon(true);
        this.setName("Discord Integration Launch Thread");
        this.start();
    }

    public void registerEventHandler(@Nonnull DiscordEventHandler handler) {
        if (!this.eventHandlers.contains(handler)) {
            this.eventHandlers.add(handler);
        }
    }

    public void unregisterEventHandler(@Nonnull DiscordEventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    private void unregisterAllEventHandlers() {
        this.eventHandlers.clear();
    }

    public void addRecentMessage(@Nonnull String msgID, @Nonnull UUID uuid) {
        if (this.recentMessages.size() + 1 >= 150) {
            do {
                this.recentMessages.remove(this.recentMessages.keySet().toArray(new String[0])[0]);
            } while (this.recentMessages.size() + 1 >= 150);
        }
        this.recentMessages.put(msgID, uuid);
    }

    @Nonnull
    public UUID getSenderUUIDFromMessageID(@Nonnull String messageID) {
        return this.recentMessages.getOrDefault(messageID, dummyUUID);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) lbl-1000:
        // 2 sources

        {
            b = JDABuilder.createDefault(Configuration.instance().general.botToken);
            b.setAutoReconnect(true);
            b.setEnableShutdownHook(false);
            b.enableIntents(GatewayIntent.DIRECT_MESSAGES, new GatewayIntent[]{GatewayIntent.GUILD_MESSAGE_REACTIONS, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES});
            b.setMemberCachePolicy(MemberCachePolicy.ALL);
            b.setChunkingFilter(ChunkingFilter.ALL);
            try {
                this.jda = b.build();
                this.jda.awaitReady();
                break;
            }
            catch (LoginException e) {
                if (e.getMessage().equals("The provided token is invalid!")) {
                    System.err.println("Invalid token, please set correct token in the config file!");
                    return;
                }
                System.err.println("Login failed, retrying");
                try {
                    Discord.sleep(6000L);
                    continue;
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
            ** while (true)
            catch (IllegalStateException | InterruptedException e) {
                return;
            }
            break;
        }
        if (this.getChannel() == null) {
            System.err.println("ERROR! Channel ID of the default bot channel not valid!");
            this.kill(true);
            return;
        }
        if (!PermissionUtil.checkPermission(this.getChannel(), this.getChannel().getGuild().getMember(this.jda.getSelfUser()), new Permission[]{Permission.MESSAGE_READ, Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS, Permission.MESSAGE_MANAGE})) {
            System.err.println("ERROR! Bot does not have all permissions to work!");
            this.kill(true);
            throw new PermissionException("Bot requires message read, message write, embed links and manage messages");
        }
        if (Configuration.instance().webhook.enable && !PermissionUtil.checkPermission(this.getChannel(), this.getChannel().getGuild().getMember(this.jda.getSelfUser()), new Permission[]{Permission.MANAGE_WEBHOOKS})) {
            System.err.println("ERROR! Bot does not have permission to manage webhooks, disabling webhook");
            Configuration.instance().webhook.enable = false;
            Configuration.instance().saveConfig();
        }
        System.out.println("Bot Ready");
        v0 = new Object[1];
        this.listener = new DiscordEventListener();
        v0[0] = this.listener;
        this.jda.addEventListener(v0);
        try {
            this.loadIgnoreList();
        }
        catch (IOException e) {
            System.err.println("Error while loading the ignoring players list!");
            e.printStackTrace();
        }
        System.out.println("Caching members...");
        this.jda.getGuilds().forEach((Consumer<Guild>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$run$2(net.dv8tion.jda.api.entities.Guild ), (Lnet/dv8tion/jda/api/entities/Guild;)V)());
        t = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$3(), ()V)((Discord)this));
        t.setName("Discord Integration Addon-Loader");
        t.setDaemon(true);
        t.start();
    }

    @Nullable
    public WebhookClient getWebhookCli(@Nonnull String channel) {
        return this.webhookClis.computeIfAbsent(channel, id -> WebhookClient.withUrl(this.getWebhook(this.getChannel((String)id)).getUrl()));
    }

    public void kill(boolean instant) {
        AddonLoader.unloadAddons(this);
        if (this.jda != null) {
            this.jda.removeEventListener(this.listener);
            this.stopThreads();
            this.unregisterAllEventHandlers();
            this.webhookClis.forEach((i, w) -> w.close());
            try {
                if (instant) {
                    this.jda.shutdownNow();
                } else {
                    this.jda.shutdown();
                }
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            this.jda = null;
            Variables.discord_instance = null;
        }
    }

    public void kill() {
        this.kill(true);
    }

    @Nullable
    public TextChannel getChannel() {
        return this.getChannel("default");
    }

    @Nullable
    public TextChannel getChannel(@Nonnull String id) {
        boolean deflt;
        if (this.jda == null) {
            return null;
        }
        boolean bl = deflt = id.equals("default") || id.equals(Configuration.instance().general.botChannel);
        if (deflt) {
            id = Configuration.instance().general.botChannel;
        }
        if (id.isEmpty()) {
            System.err.println("Cannot get channel from empty ID! Check your config!");
            if (deflt) {
                return null;
            }
            System.out.println("Falling back to default channel!");
            return this.getChannel();
        }
        TextChannel channel = this.channelCache.computeIfAbsent(id, id2 -> this.jda.getTextChannelById((String)id2));
        if (channel == null) {
            System.err.println("Failed to get channel with ID '" + id + "', falling back to default channel");
            channel = this.channelCache.computeIfAbsent(Configuration.instance().general.botChannel, this.jda::getTextChannelById);
        }
        return channel;
    }

    public void loadIgnoreList() throws IOException {
        if (IGNORED_PLAYERS.exists()) {
            BufferedReader r = new BufferedReader(new FileReader(IGNORED_PLAYERS));
            r.lines().iterator().forEachRemaining(s -> {
                try {
                    this.ignoringPlayers.add(UUID.fromString(s));
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Found invalid entry for ignoring player, skipping");
                }
            });
            r.close();
        }
    }

    public void startThreads() {
        if (this.statusUpdater == null) {
            this.statusUpdater = new StatusUpdateThread();
        }
        if (this.messageSender == null) {
            this.messageSender = new MessageQueueThread();
        }
        if (!this.messageSender.isAlive()) {
            this.messageSender.start();
        }
        if (!this.statusUpdater.isAlive()) {
            this.statusUpdater.start();
        }
    }

    public void stopThreads() {
        if (this.messageSender != null && this.messageSender.isAlive()) {
            this.messageSender.interrupt();
        }
        if (this.statusUpdater != null && this.statusUpdater.isAlive()) {
            this.statusUpdater.interrupt();
        }
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    @Nullable
    public JDA getJDA() {
        return this.jda;
    }

    public void sendMessageFuture(@Nonnull String msg, @Nonnull String channelID) {
        if (msg.isEmpty() || channelID.isEmpty()) {
            return;
        }
        ArrayList<String> msgs = this.messages.containsKey(channelID) ? this.messages.get(channelID) : new ArrayList<String>();
        msgs.add(msg);
        this.messages.put(channelID, msgs);
    }

    public void sendMessage(@Nonnull String playerName, @Nonnull String uuid, @Nonnull MessageEmbed embed, @Nonnull TextChannel channel) {
        this.sendMessage(playerName, uuid, new DiscordMessage(embed), channel);
    }

    public void sendMessage(@Nonnull String msg) {
        this.sendMessage(Configuration.instance().webhook.serverName, "0000000", msg, this.getChannel(Configuration.instance().advanced.serverChannelID));
    }

    public void sendMessage(@Nonnull String playerName, @Nonnull String uuid, @Nonnull String msg, TextChannel channel) {
        this.sendMessage(playerName, uuid, new DiscordMessage(msg), channel);
    }

    public void sendMessage(TextChannel channel, @Nonnull String message, @Nonnull String avatarURL, @Nonnull String name) {
        this.sendMessage(name, new DiscordMessage(message), avatarURL, channel, false);
    }

    public void sendMessage(@Nonnull String msg, @Nonnull String avatarURL, @Nonnull String name) {
        this.sendMessage(name, new DiscordMessage(msg), avatarURL, this.getChannel(Configuration.instance().advanced.serverChannelID), true);
    }

    public void sendMessage(@Nonnull String name, @Nonnull String msg, TextChannel channel, @Nonnull String avatarURL) {
        this.sendMessage(name, new DiscordMessage(msg), avatarURL, channel, true);
    }

    public void sendMessage(@Nonnull String name, @Nonnull DiscordMessage message, @Nonnull String avatarURL, TextChannel channel, boolean isChatMessage) {
        this.sendMessage(name, message, avatarURL, channel, isChatMessage, dummyUUID.toString());
    }

    public void sendMessage(@Nonnull String name, @Nonnull DiscordMessage message, @Nonnull String avatarURL, TextChannel channel, boolean isChatMessage, @Nonnull String uuid) {
        if (this.jda == null || channel == null) {
            return;
        }
        try {
            if (Configuration.instance().webhook.enable) {
                WebhookMessageBuilder b = message.buildWebhookMessage();
                b.setUsername(name);
                b.setAvatarUrl(avatarURL);
                this.getWebhookCli(channel.getId()).send(b.build()).thenAccept(a -> this.addRecentMessage(a.getId() + "", UUID.fromString(uuid)));
            } else if (isChatMessage) {
                message.setMessage(Configuration.instance().localization.discordChatMessage.replace("%player%", name).replace("%msg%", message.getMessage()));
                channel.sendMessage(message.buildMessage()).submit().thenAccept(a -> this.addRecentMessage(a.getId(), UUID.fromString(uuid)));
            } else {
                channel.sendMessage(message.buildMessage()).submit().thenAccept(a -> this.addRecentMessage(a.getId(), UUID.fromString(uuid)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public Webhook getWebhook(TextChannel c) {
        if (!Configuration.instance().webhook.enable || c == null) {
            return null;
        }
        return this.webhookHashMap.computeIfAbsent(c.getId(), cid -> {
            if (!PermissionUtil.checkPermission(c, c.getGuild().getMember(this.jda.getSelfUser()), Permission.MANAGE_WEBHOOKS)) {
                System.out.println("ERROR! Bot does not have permission to manage webhooks, disabling webhook");
                Configuration.instance().webhook.enable = false;
                Configuration.instance().saveConfig();
                return null;
            }
            for (Webhook web : c.retrieveWebhooks().complete()) {
                if (!web.getName().equals("MC_DISCORD_INTEGRATION")) continue;
                return web;
            }
            return (Webhook)c.createWebhook("MC_DISCORD_INTEGRATION").complete();
        });
    }

    @Nullable
    public CompletableFuture<Message> sendMessageReturns(@Nonnull String msg, TextChannel c) {
        if (Configuration.instance().webhook.enable || msg.isEmpty() || c == null) {
            return null;
        }
        return c.sendMessage(msg).submit();
    }

    public void sendMessage(@Nonnull String msg, TextChannel textChannel) {
        this.sendMessage(new DiscordMessage(msg), textChannel);
    }

    public void sendMessage(@Nonnull DiscordMessage msg, TextChannel channel) {
        this.sendMessage(Configuration.instance().webhook.serverName, "0000000", msg, channel);
    }

    public boolean restart() {
        try {
            this.kill();
            if (Variables.discord_instance.isAlive()) {
                Variables.discord_instance.interrupt();
            }
            Variables.discord_instance = new Discord(this.srv);
            CommandRegistry.reRegisterAllCommands();
            CommandRegistry.registerConfigCommands();
            Variables.discord_instance.startThreads();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nonnull
    public HashMap<String, String> getSettings() {
        HashMap<String, String> out = new HashMap<String, String>();
        Field[] fields = PlayerSettings.class.getFields();
        Field[] descFields = PlayerSettings.Descriptions.class.getDeclaredFields();
        for (Field f : fields) {
            out.put(f.getName(), "No Description Provided");
        }
        for (Field f : descFields) {
            f.setAccessible(true);
            try {
                out.put(f.getName(), (String)f.get(new PlayerSettings.Descriptions()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    public void sendMessage(@Nonnull String playerName, @Nonnull String uuid, @Nonnull DiscordMessage msg, TextChannel channel) {
        if (channel == null) {
            return;
        }
        boolean isServerMessage = playerName.equals(Configuration.instance().webhook.serverName) && uuid.equals("0000000");
        UUID uUUID = uuid.equals("0000000") ? null : UUID.fromString(uuid);
        String avatarURL = "";
        if (!isServerMessage && uUUID != null) {
            if (PlayerLinkController.isPlayerLinked(uUUID)) {
                PlayerSettings s = PlayerLinkController.getSettings(null, uUUID);
                Member dc = channel.getGuild().getMemberById(PlayerLinkController.getDiscordFromPlayer(uUUID));
                if (s.useDiscordNameInChannel) {
                    playerName = dc.getEffectiveName();
                    avatarURL = dc.getUser().getAvatarUrl();
                }
            }
            if (avatarURL != null && avatarURL.isEmpty()) {
                avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", uUUID.toString()).replace("%uuid_dashless%", uUUID.toString().replace("-", "")).replace("%name%", playerName).replace("%randomUUID%", UUID.randomUUID().toString());
            }
        }
        if (isServerMessage) {
            avatarURL = Configuration.instance().webhook.serverAvatarURL;
        }
        this.sendMessage(playerName, msg, avatarURL, channel, !isServerMessage, uuid);
    }

    public boolean togglePlayerIgnore(@Nonnull UUID uuid) {
        if (PlayerLinkController.isPlayerLinked(uuid)) {
            PlayerSettings settings = PlayerLinkController.getSettings(null, uuid);
            settings.ignoreDiscordChatIngame = !settings.ignoreDiscordChatIngame;
            PlayerLinkController.updatePlayerSettings(null, uuid, settings);
            return !settings.ignoreDiscordChatIngame;
        }
        if (this.ignoringPlayers.contains(uuid)) {
            this.ignoringPlayers.remove(uuid);
            try {
                this.saveIgnoreList();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        this.ignoringPlayers.add(uuid);
        return false;
    }

    public int genLinkNumber(@Nonnull UUID uniqueID) {
        AtomicInteger r = new AtomicInteger(-1);
        this.pendingLinks.forEach((k, v) -> {
            if (((UUID)v.getValue()).equals(uniqueID)) {
                r.set((int)k);
            }
        });
        if (r.get() != -1) {
            return r.get();
        }
        do {
            r.set(new Random().nextInt(Integer.MAX_VALUE));
        } while (this.pendingLinks.containsKey(r.get()));
        this.pendingLinks.put(r.get(), new DefaultKeyValue<Instant, UUID>(Instant.now(), uniqueID));
        return r.get();
    }

    public int genBedrockLinkNumber(@Nonnull UUID uniqueID) {
        AtomicInteger r = new AtomicInteger(-1);
        this.pendingBedrockLinks.forEach((k, v) -> {
            if (((UUID)v.getValue()).equals(uniqueID)) {
                r.set((int)k);
            }
        });
        if (r.get() != -1) {
            return r.get();
        }
        do {
            r.set(new Random().nextInt(99999));
        } while (this.pendingBedrockLinks.containsKey(r.get()));
        this.pendingBedrockLinks.put(r.get(), new DefaultKeyValue<Instant, UUID>(Instant.now(), uniqueID));
        return r.get();
    }

    private void saveIgnoreList() throws IOException {
        if (!IGNORED_PLAYERS.exists() && !this.ignoringPlayers.isEmpty()) {
            IGNORED_PLAYERS.createNewFile();
        }
        if (!IGNORED_PLAYERS.exists() && this.ignoringPlayers.isEmpty()) {
            IGNORED_PLAYERS.delete();
            return;
        }
        FileWriter w = new FileWriter(IGNORED_PLAYERS);
        w.write("");
        for (UUID a : this.ignoringPlayers) {
            if (PlayerLinkController.isPlayerLinked(a)) continue;
            w.append(a.toString()).append("\n");
        }
        w.close();
    }

    public boolean hasAdminRole(@Nonnull List<Role> roles) {
        AtomicBoolean ret = new AtomicBoolean(false);
        roles.forEach(r -> {
            for (String id : Configuration.instance().commands.adminRoleIDs) {
                if (!id.equals(r.getId())) continue;
                ret.set(true);
            }
        });
        return ret.get();
    }

    public boolean callEvent(@Nonnull Function<DiscordEventHandler, Boolean> func) {
        for (DiscordEventHandler h : this.eventHandlers) {
            if (!func.apply(h).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void callEventC(@Nonnull Consumer<DiscordEventHandler> consumer) {
        for (DiscordEventHandler h : this.eventHandlers) {
            consumer.accept(h);
        }
    }

    private /* synthetic */ void lambda$run$3() {
        System.out.println("Loading DiscordIntegration addons...");
        AddonLoader.loadAddons(this);
        System.out.println("Addon loading complete!");
    }

    private static /* synthetic */ void lambda$run$2(Guild g) {
        g.loadMembers().onSuccess(m -> System.out.println("All " + m.size() + " members cached for Guild " + g.getName())).onError(t -> {
            System.err.println("Encountered an error while caching members:");
            t.printStackTrace();
        });
    }

    private class StatusUpdateThread
    extends Thread {
        StatusUpdateThread() {
            this.setName("[Discord Integration] Discord status updater and link cleanup");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                int i;
                if (Discord.this.jda != null) {
                    String game = Configuration.instance().general.botStatusName.replace("%online%", "" + Discord.this.srv.getOnlinePlayers()).replace("%max%", "" + Discord.this.srv.getMaxPlayers());
                    switch (Configuration.instance().general.botStatusType) {
                        case DISABLED: {
                            break;
                        }
                        case LISTENING: {
                            Discord.this.jda.getPresence().setActivity(Activity.listening(game));
                            break;
                        }
                        case PLAYING: {
                            Discord.this.jda.getPresence().setActivity(Activity.playing(game));
                            break;
                        }
                        case WATCHING: {
                            Discord.this.jda.getPresence().setActivity(Activity.watching(game));
                            break;
                        }
                        case STREAMING: {
                            Discord.this.jda.getPresence().setActivity(Activity.streaming(game, Configuration.instance().general.streamingURL));
                        }
                    }
                }
                ArrayList remove = new ArrayList();
                Discord.this.pendingLinks.forEach((k, v) -> {
                    Instant now = Instant.now();
                    Duration d = Duration.between((Temporal)v.getKey(), now);
                    if (d.toMinutes() > 10L) {
                        remove.add(k);
                    }
                });
                Iterator iterator2 = remove.iterator();
                while (iterator2.hasNext()) {
                    i = (Integer)iterator2.next();
                    Discord.this.pendingLinks.remove(i);
                }
                remove.clear();
                Discord.this.pendingBedrockLinks.forEach((k, v) -> {
                    Instant now = Instant.now();
                    Duration d = Duration.between((Temporal)v.getKey(), now);
                    if (d.toMinutes() > 10L) {
                        remove.add(k);
                    }
                });
                iterator2 = remove.iterator();
                while (iterator2.hasNext()) {
                    i = (Integer)iterator2.next();
                    Discord.this.pendingBedrockLinks.remove(i);
                }
                try {
                    StatusUpdateThread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private class MessageQueueThread
    extends Thread {
        MessageQueueThread() {
            this.setName("[Discord Integration] Message Queue");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                if (!Discord.this.messages.isEmpty()) {
                    Discord.this.messages.forEach((channel, msgs) -> {
                        StringBuilder s = new StringBuilder();
                        for (String msg : msgs) {
                            s.append(msg).append("\n");
                        }
                        Discord.this.sendMessage(s.toString().trim(), Discord.this.getChannel((String)channel));
                    });
                    Discord.this.messages.clear();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

