/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.addon;

import dcshadow.com.moandjiezana.toml.Toml;
import dcshadow.com.moandjiezana.toml.TomlWriter;
import dcshadow.javax.annotation.Nonnull;
import dcshadow.javax.annotation.Nullable;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonConfiguration;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordIntegrationAddon;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class AddonConfigRegistry {
    @Nullable
    public static <T extends AddonConfiguration> T loadConfig(@Nonnull T cfg) {
        if (cfg.getConfigFile() == null) {
            return null;
        }
        if (!cfg.getConfigFile().exists()) {
            AddonConfigRegistry.saveConfig(cfg);
            return cfg;
        }
        File cfgFile = cfg.getConfigFile();
        AddonConfiguration conf = (AddonConfiguration)new Toml().read(cfgFile).to(cfg.getClass());
        conf.setConfigFile(cfgFile);
        AddonConfigRegistry.saveConfig(conf);
        return (T)conf;
    }

    public static void saveConfig(@Nonnull AddonConfiguration cfg) {
        if (cfg.getConfigFile() == null) {
            return;
        }
        try {
            if (!cfg.getConfigFile().exists()) {
                if (!cfg.getConfigFile().getParentFile().exists()) {
                    cfg.getConfigFile().getParentFile().mkdirs();
                }
                cfg.getConfigFile().createNewFile();
            }
            TomlWriter w = new TomlWriter.Builder().indentValuesBy(2).indentTablesBy(4).padArrayDelimitersBy(2).build();
            w.write((Object)cfg, cfg.getConfigFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static <T extends AddonConfiguration> T registerConfig(@Nonnull Class<T> cfg, @Nonnull DiscordIntegrationAddon inst) {
        try {
            AddonConfiguration conf = (AddonConfiguration)cfg.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            conf.setConfigFile(new File(AddonLoader.getAddonDir(), AddonLoader.getAddonMeta(inst).getName() + ".toml"));
            return (T)AddonConfigRegistry.loadConfig(conf);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("An exception occurred while loading addon configuration " + cfg.getName());
            e.printStackTrace();
            return null;
        }
    }
}

